<?php $__env->startSection('title', 'General Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <!-- Breadcrumb -->
        <nav class="flex mb-6" aria-label="Breadcrumb">
            <ol class="inline-flex items-center space-x-1 md:space-x-3">
                <li class="inline-flex items-center">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-gray-400 hover:text-white">
                        Admin
                    </a>
                </li>
                <li>
                    <div class="flex items-center">
                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <a href="<?php echo e(route('admin.settings.index')); ?>" class="ml-1 text-gray-400 hover:text-white">
                            Settings
                        </a>
                    </div>
                </li>
                <li aria-current="page">
                    <div class="flex items-center">
                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="ml-1 text-gray-500">General Settings</span>
                    </div>
                </li>
            </ol>
        </nav>

        <!-- Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">General Settings</h1>
            <p class="text-gray-400">Configure site name, currency, tax rates, and basic system settings</p>
        </div>

        <?php if(session('success')): ?>
            <div class="mb-6 p-4 bg-green-500/10 border border-green-500 text-green-400 rounded-lg flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Settings Form -->
        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            <form method="POST" action="<?php echo e(route('admin.settings.general.update')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                
                <!-- Site Information Section -->
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-white mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Site Information
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Site Name</label>
                            <input type="text" name="site_name" value="<?php echo e($settings['site_name'] ?? config('app.name')); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500" required>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Site URL</label>
                            <input type="url" name="site_url" value="<?php echo e($settings['site_url'] ?? config('app.url')); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500" required>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Site Email Address</label>
                            <input type="email" name="site_email" value="<?php echo e($settings['site_email'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="contact@example.com">
                            <p class="text-sm text-gray-400 mt-1">Primary contact email for the site</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Site Physical Address</label>
                            <input type="text" name="site_address" value="<?php echo e($settings['site_address'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="123 Main St, City, State, ZIP">
                            <p class="text-sm text-gray-400 mt-1">Physical business address</p>
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-300 mb-2">Site Logo URL</label>
                            <input type="url" name="site_logo" value="<?php echo e($settings['site_logo'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="https://example.com/logo.png">
                            <p class="text-sm text-gray-400 mt-1">Enter a URL to your logo image (PNG, JPG, or SVG recommended)</p>
                            <?php if(!empty($settings['site_logo'])): ?>
                                <div class="mt-3 p-3 bg-gray-700 rounded-lg">
                                    <p class="text-sm text-gray-300 mb-2">Current Logo:</p>
                                    <img src="<?php echo e($settings['site_logo']); ?>" alt="Site Logo" class="h-12 object-contain">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Currency Settings Section -->
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-white mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Currency Settings
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Default Currency</label>
                            <select name="currency" class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500">
                                <option value="USD" <?php echo e(($settings['currency'] ?? 'USD') === 'USD' ? 'selected' : ''); ?>>USD ($)</option>
                                <option value="EUR" <?php echo e(($settings['currency'] ?? 'USD') === 'EUR' ? 'selected' : ''); ?>>EUR (€)</option>
                                <option value="GBP" <?php echo e(($settings['currency'] ?? 'USD') === 'GBP' ? 'selected' : ''); ?>>GBP (£)</option>
                                <option value="CAD" <?php echo e(($settings['currency'] ?? 'USD') === 'CAD' ? 'selected' : ''); ?>>CAD ($)</option>
                                <option value="AUD" <?php echo e(($settings['currency'] ?? 'USD') === 'AUD' ? 'selected' : ''); ?>>AUD ($)</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Tax Rate (%)</label>
                            <input type="number" name="tax_rate" value="<?php echo e($settings['tax_rate'] ?? 0); ?>" step="0.01" min="0" max="100"
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500">
                        </div>
                    </div>
                </div>

                <!-- System Options Section -->
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-white mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        System Options
                    </h3>
                    <div class="space-y-4">
                        <label class="flex items-center">
                            <input type="checkbox" name="enable_registration" value="1" 
                                   <?php echo e(($settings['enable_registration'] ?? true) ? 'checked' : ''); ?>

                                   class="w-4 h-4 bg-gray-700 border-gray-600 rounded text-blue-600 focus:ring-blue-500 focus:ring-2">
                            <span class="ml-3 text-sm text-gray-300">Enable Public Registration</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="maintenance_mode" value="1" 
                                   <?php echo e(($settings['maintenance_mode'] ?? false) ? 'checked' : ''); ?>

                                   class="w-4 h-4 bg-gray-700 border-gray-600 rounded text-blue-600 focus:ring-blue-500 focus:ring-2">
                            <span class="ml-3 text-sm text-gray-300">Enable Maintenance Mode</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="auto_invoice_generation" value="1" 
                                   <?php echo e(($settings['auto_invoice_generation'] ?? true) ? 'checked' : ''); ?>

                                   class="w-4 h-4 bg-gray-700 border-gray-600 rounded text-blue-600 focus:ring-blue-500 focus:ring-2">
                            <span class="ml-3 text-sm text-gray-300">Auto-generate Invoices</span>
                        </label>
                    </div>
                </div>

                <!-- Maintenance Mode Configuration -->
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-white mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                        </svg>
                        Maintenance Mode Configuration
                    </h3>
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Maintenance Message</label>
                            <textarea name="maintenance_message" rows="3" 
                                      class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                      placeholder="We'll be back soon! We're currently performing scheduled maintenance."><?php echo e($settings['maintenance_message'] ?? ''); ?></textarea>
                            <p class="text-sm text-gray-400 mt-1">Message displayed to visitors during maintenance mode</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Maintenance Redirect URL (Optional)</label>
                            <input type="url" name="maintenance_redirect_url" value="<?php echo e($settings['maintenance_redirect_url'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="https://status.example.com">
                            <p class="text-sm text-gray-400 mt-1">Optional URL to redirect users during maintenance (leave empty to show maintenance page)</p>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center justify-end space-x-4">
                    <a href="<?php echo e(route('admin.settings.index')); ?>" 
                       class="px-6 py-2 bg-gray-700 text-white rounded-lg hover:bg-gray-600 transition">
                        Cancel
                    </a>
                    <button type="submit" 
                            class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        Save Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\BillingSystem\BillingCS-main\resources\views/admin/settings/categories/general.blade.php ENDPATH**/ ?>