<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\AdminLoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Client\DashboardController as ClientDashboardController;
use App\Http\Controllers\Client\ServiceController as ClientServiceController;
use App\Http\Controllers\Client\InvoiceController as ClientInvoiceController;
use App\Http\Controllers\Client\TicketController as ClientTicketController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\ServiceController as AdminServiceController;
use App\Http\Controllers\Admin\InvoiceController as AdminInvoiceController;
use App\Http\Controllers\Admin\TicketController as AdminTicketController;
use App\Http\Controllers\Admin\SettingController;

Route::get('/', function () {
    // Get popular TLDs for display
    $popularTlds = \App\Models\DomainPricing::where('active', true)
        ->whereIn('extension', ['.com', '.net', '.org', '.io'])
        ->get()
        ->keyBy('extension');
    
    return view('welcome', compact('popularTlds'));
})->name('home');

// Public Routes - Order Pages
Route::get('/order/hosting', function () {
    $products = \App\Models\Product::where('active', true)->where('type', 'hosting')->with('pricing')->get();
    return view('client.order.hosting', compact('products'));
})->name('order.hosting');

Route::get('/order/vps', function () {
    $products = \App\Models\Product::where('active', true)->where('type', 'vps')->with('pricing')->get();
    return view('client.order.vps', compact('products'));
})->name('order.vps');

Route::get('/order/dedicated', function () {
    $products = \App\Models\Product::where('active', true)->where('type', 'dedicated')->with('pricing')->get();
    return view('client.order.dedicated', compact('products'));
})->name('order.dedicated');

Route::get('/domain/search', function () {
    return view('client.domain.search');
})->name('domain.search');

Route::post('/domain/check', [App\Http\Controllers\DomainController::class, 'check'])->name('domain.check');

// Cart Routes
Route::get('/cart', [App\Http\Controllers\CartController::class, 'index'])->name('cart.index');
Route::post('/cart/product/{product}', [App\Http\Controllers\CartController::class, 'addProduct'])->name('cart.add.product');
Route::post('/cart/domain', [App\Http\Controllers\CartController::class, 'addDomain'])->name('cart.add.domain');
Route::delete('/cart/{index}', [App\Http\Controllers\CartController::class, 'remove'])->name('cart.remove');
Route::post('/cart/clear', [App\Http\Controllers\CartController::class, 'clear'])->name('cart.clear');
Route::post('/cart/checkout', [App\Http\Controllers\CartController::class, 'checkout'])->middleware('auth')->name('cart.checkout');

// Authentication Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');
Route::get('/register', [RegisterController::class, 'showRegistrationForm'])->name('register');
Route::post('/register', [RegisterController::class, 'register']);

// Admin Authentication Routes
Route::get('/admin/login', [AdminLoginController::class, 'showLoginForm'])->name('admin.login');
Route::post('/admin/login', [AdminLoginController::class, 'login']);
Route::post('/admin/logout', [AdminLoginController::class, 'logout'])->name('admin.logout');

// Client Routes
Route::middleware(['auth', 'client'])->prefix('client')->name('client.')->group(function () {
    Route::get('/dashboard', [ClientDashboardController::class, 'index'])->name('dashboard');
    
    // Products
    Route::get('/products/{product}', [\App\Http\Controllers\Client\ProductController::class, 'show'])->name('products.show');
    
    // Services
    Route::prefix('services')->name('services.')->group(function () {
        Route::get('/', [ClientServiceController::class, 'index'])->name('index');
        Route::get('/{service}', [ClientServiceController::class, 'show'])->name('show');
    });
    
    // Domains
    Route::prefix('domains')->name('domains.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Client\DomainController::class, 'index'])->name('index');
        Route::get('/register', [\App\Http\Controllers\Client\DomainController::class, 'register'])->name('register');
        Route::get('/transfer', [\App\Http\Controllers\Client\DomainController::class, 'transfer'])->name('transfer');
        Route::get('/pricing', [\App\Http\Controllers\Client\DomainController::class, 'pricing'])->name('pricing');
    });
    
    // Invoices
    Route::prefix('invoices')->name('invoices.')->group(function () {
        Route::get('/', [ClientInvoiceController::class, 'index'])->name('index');
        Route::get('/{invoice}', [ClientInvoiceController::class, 'show'])->name('show');
        Route::get('/{invoice}/pdf', [ClientInvoiceController::class, 'pdf'])->name('pdf');
        Route::post('/{invoice}/pay', [ClientInvoiceController::class, 'pay'])->name('pay');
    });
    
    // Tickets
    Route::prefix('tickets')->name('tickets.')->group(function () {
        Route::get('/', [ClientTicketController::class, 'index'])->name('index');
        Route::get('/create', [ClientTicketController::class, 'create'])->name('create');
        Route::post('/', [ClientTicketController::class, 'store'])->name('store');
        Route::get('/{ticket}', [ClientTicketController::class, 'show'])->name('show');
        Route::post('/{ticket}/reply', [ClientTicketController::class, 'reply'])->name('reply');
    });
    
    // Support
    Route::get('/announcements', [\App\Http\Controllers\Client\SupportController::class, 'announcements'])->name('announcements');
    Route::get('/knowledgebase', [\App\Http\Controllers\Client\SupportController::class, 'knowledgebase'])->name('knowledgebase');
    Route::get('/downloads', [\App\Http\Controllers\Client\SupportController::class, 'downloads'])->name('downloads');
    Route::get('/network-status', [\App\Http\Controllers\Client\SupportController::class, 'networkStatus'])->name('network-status');
    
    // Account
    Route::prefix('account')->name('account.')->group(function () {
        Route::get('/overview', [\App\Http\Controllers\Client\AccountController::class, 'overview'])->name('overview');
        Route::get('/profile', [\App\Http\Controllers\Client\AccountController::class, 'profile'])->name('profile');
        Route::put('/profile', [\App\Http\Controllers\Client\AccountController::class, 'updateProfile'])->name('profile.update');
        Route::get('/security', [\App\Http\Controllers\Client\AccountController::class, 'security'])->name('security');
        Route::put('/security', [\App\Http\Controllers\Client\AccountController::class, 'updatePassword'])->name('security.update');
        Route::get('/contacts', [\App\Http\Controllers\Client\AccountController::class, 'contacts'])->name('contacts');
        Route::get('/add-funds', [\App\Http\Controllers\Client\AccountController::class, 'addFunds'])->name('add-funds');
        Route::get('/messages', [\App\Http\Controllers\Client\AccountController::class, 'messages'])->name('messages');
    });
    
    // Contact
    Route::get('/contact', [\App\Http\Controllers\Client\ContactController::class, 'index'])->name('contact');
    Route::post('/contact', [\App\Http\Controllers\Client\ContactController::class, 'submit'])->name('contact.submit');
});

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
    
    // Quick Actions (New menu)
    Route::prefix('new')->name('new.')->group(function () {
        Route::get('/client', [\App\Http\Controllers\Admin\QuickActionsController::class, 'newClient'])->name('client');
        Route::post('/client', [\App\Http\Controllers\Admin\QuickActionsController::class, 'storeClient'])->name('client.store');
        Route::get('/order', [\App\Http\Controllers\Admin\QuickActionsController::class, 'newOrder'])->name('order');
        Route::post('/order', [\App\Http\Controllers\Admin\QuickActionsController::class, 'storeOrder'])->name('order.store');
        Route::get('/invoice', [\App\Http\Controllers\Admin\QuickActionsController::class, 'newInvoice'])->name('invoice');
        Route::post('/invoice', [\App\Http\Controllers\Admin\QuickActionsController::class, 'storeInvoice'])->name('invoice.store');
        Route::get('/quote', [\App\Http\Controllers\Admin\QuickActionsController::class, 'newQuote'])->name('quote');
        Route::post('/quote', [\App\Http\Controllers\Admin\QuickActionsController::class, 'storeQuote'])->name('quote.store');
        Route::get('/ticket', [\App\Http\Controllers\Admin\QuickActionsController::class, 'newTicket'])->name('ticket');
        Route::post('/ticket', [\App\Http\Controllers\Admin\QuickActionsController::class, 'storeTicket'])->name('ticket.store');
    });

    // Clients Section
    Route::prefix('clients')->name('clients.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\Clients\ClientController::class, 'index'])->name('index');
        Route::get('/{id}', [\App\Http\Controllers\Admin\Clients\ClientController::class, 'show'])->name('show');
        Route::get('/products-services', [\App\Http\Controllers\Admin\Clients\ClientController::class, 'products'])->name('products');
        Route::get('/addons', [\App\Http\Controllers\Admin\Clients\ClientController::class, 'addons'])->name('addons');
        Route::get('/domains', [\App\Http\Controllers\Admin\Clients\ClientController::class, 'domains'])->name('domains');
        Route::get('/cancellations', [\App\Http\Controllers\Admin\Clients\ClientController::class, 'cancellations'])->name('cancellations');
        Route::get('/affiliates', [\App\Http\Controllers\Admin\Clients\ClientController::class, 'affiliates'])->name('affiliates');
    });

    // Orders Section
    Route::prefix('orders')->name('orders.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\Orders\OrderController::class, 'index'])->name('index');
        Route::get('/pending', [\App\Http\Controllers\Admin\Orders\OrderController::class, 'pending'])->name('pending');
        Route::get('/active', [\App\Http\Controllers\Admin\Orders\OrderController::class, 'active'])->name('active');
        Route::get('/fraud', [\App\Http\Controllers\Admin\Orders\OrderController::class, 'fraud'])->name('fraud');
        Route::get('/cancelled', [\App\Http\Controllers\Admin\Orders\OrderController::class, 'cancelled'])->name('cancelled');
    });

    // Billing Section
    Route::prefix('billing')->name('billing.')->group(function () {
        // Transactions
        Route::get('/transactions', [\App\Http\Controllers\Admin\Billing\TransactionController::class, 'index'])->name('transactions');
        Route::get('/gateway-log', [\App\Http\Controllers\Admin\Billing\TransactionController::class, 'gatewayLog'])->name('gateway-log');
        
        // Invoices
        Route::prefix('invoices')->name('invoices.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\Billing\InvoiceController::class, 'index'])->name('index');
            Route::get('/paid', [\App\Http\Controllers\Admin\Billing\InvoiceController::class, 'paid'])->name('paid');
            Route::get('/draft', [\App\Http\Controllers\Admin\Billing\InvoiceController::class, 'draft'])->name('draft');
            Route::get('/unpaid', [\App\Http\Controllers\Admin\Billing\InvoiceController::class, 'unpaid'])->name('unpaid');
            Route::get('/overdue', [\App\Http\Controllers\Admin\Billing\InvoiceController::class, 'overdue'])->name('overdue');
            Route::get('/cancelled', [\App\Http\Controllers\Admin\Billing\InvoiceController::class, 'cancelled'])->name('cancelled');
            Route::get('/refunded', [\App\Http\Controllers\Admin\Billing\InvoiceController::class, 'refunded'])->name('refunded');
        });
        
        // Billable Items
        Route::prefix('billable')->name('billable.')->group(function () {
            Route::get('/uninvoiced', [\App\Http\Controllers\Admin\Billing\BillableItemController::class, 'uninvoiced'])->name('uninvoiced');
            Route::get('/recurring', [\App\Http\Controllers\Admin\Billing\BillableItemController::class, 'recurring'])->name('recurring');
            Route::get('/create', [\App\Http\Controllers\Admin\Billing\BillableItemController::class, 'create'])->name('create');
        });
        
        // Quotes
        Route::get('/quotes', [\App\Http\Controllers\Admin\Billing\QuoteController::class, 'index'])->name('quotes');
        
        // Disputes
        Route::get('/disputes', [\App\Http\Controllers\Admin\Billing\DisputeController::class, 'index'])->name('disputes');
    });

    // Support Section
    Route::prefix('support')->name('support.')->group(function () {
        Route::get('/overview', [\App\Http\Controllers\Admin\Support\SupportController::class, 'overview'])->name('overview');
        
        // Tickets
        Route::prefix('tickets')->name('tickets.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\Support\SupportController::class, 'tickets'])->name('index');
            Route::get('/flagged', [\App\Http\Controllers\Admin\Support\SupportController::class, 'flagged'])->name('flagged');
            Route::get('/open', [\App\Http\Controllers\Admin\Support\SupportController::class, 'open'])->name('open');
            Route::get('/answered', [\App\Http\Controllers\Admin\Support\SupportController::class, 'answered'])->name('answered');
            Route::get('/customer-reply', [\App\Http\Controllers\Admin\Support\SupportController::class, 'customerReply'])->name('customer-reply');
            Route::get('/on-hold', [\App\Http\Controllers\Admin\Support\SupportController::class, 'onHold'])->name('on-hold');
            Route::get('/in-progress', [\App\Http\Controllers\Admin\Support\SupportController::class, 'inProgress'])->name('in-progress');
            Route::get('/closed', [\App\Http\Controllers\Admin\Support\SupportController::class, 'closed'])->name('closed');
        });
        
        Route::get('/predefined-replies', [\App\Http\Controllers\Admin\Support\SupportController::class, 'predefinedReplies'])->name('predefined-replies');
        Route::get('/announcements', [\App\Http\Controllers\Admin\Support\SupportController::class, 'announcements'])->name('announcements');
        Route::get('/downloads', [\App\Http\Controllers\Admin\Support\SupportController::class, 'downloads'])->name('downloads');
        Route::get('/knowledgebase', [\App\Http\Controllers\Admin\Support\SupportController::class, 'knowledgebase'])->name('knowledgebase');
        Route::get('/network-issues', [\App\Http\Controllers\Admin\Support\SupportController::class, 'networkIssues'])->name('network-issues');
    });

    // Reports Section
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\Reports\ReportController::class, 'index'])->name('index');
        Route::get('/daily-performance', [\App\Http\Controllers\Admin\Reports\ReportController::class, 'dailyPerformance'])->name('daily-performance');
        Route::get('/income-forecast', [\App\Http\Controllers\Admin\Reports\ReportController::class, 'incomeForecast'])->name('income-forecast');
        Route::get('/annual-income', [\App\Http\Controllers\Admin\Reports\ReportController::class, 'annualIncome'])->name('annual-income');
        Route::get('/new-customers', [\App\Http\Controllers\Admin\Reports\ReportController::class, 'newCustomers'])->name('new-customers');
        Route::get('/ticket-feedback', [\App\Http\Controllers\Admin\Reports\ReportController::class, 'ticketFeedback'])->name('ticket-feedback');
        Route::get('/batch-invoice-pdf', [\App\Http\Controllers\Admin\Reports\ReportController::class, 'batchInvoicePdf'])->name('batch-invoice-pdf');
    });

    // Utilities Section
    Route::prefix('utilities')->name('utilities.')->group(function () {
        Route::get('/automation-status', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'automationStatus'])->name('automation-status');
        Route::get('/module-queue', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'moduleQueue'])->name('module-queue');
        Route::get('/registrar-tld-sync', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'registrarTldSync'])->name('registrar-tld-sync');
        Route::get('/email-campaigns', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'emailCampaigns'])->name('email-campaigns');
        Route::get('/email-marketer', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'emailMarketer'])->name('email-marketer');
        Route::get('/link-tracking', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'linkTracking'])->name('link-tracking');
        Route::get('/calendar', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'calendar'])->name('calendar');
        Route::get('/todo-list', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'todoList'])->name('todo-list');
        Route::get('/whois-lookup', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'whoisLookup'])->name('whois-lookup');
        Route::get('/domain-resolver', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'domainResolver'])->name('domain-resolver');
        Route::get('/integration-code', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'integrationCode'])->name('integration-code');
        
        // System Utilities
        Route::prefix('system')->name('system.')->group(function () {
            Route::get('/database-status', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'databaseStatus'])->name('database-status');
            Route::get('/cleanup', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'systemCleanup'])->name('cleanup');
            Route::get('/php-info', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'phpInfo'])->name('php-info');
            Route::get('/php-version', [\App\Http\Controllers\Admin\Utilities\UtilityController::class, 'phpVersionCompatibility'])->name('php-version');
        });
    });

    // Addons Section
    Route::prefix('addons')->name('addons.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\Addons\AddonController::class, 'index'])->name('index');
    });
    
    // Legacy routes (kept for backward compatibility)
    Route::resource('users', UserController::class);
    Route::resource('services', AdminServiceController::class);
    Route::resource('invoices', AdminInvoiceController::class);
    Route::resource('tickets', AdminTicketController::class);
    
    // Servers Management
    Route::resource('servers', \App\Http\Controllers\Admin\ServerController::class);
    Route::post('/servers/{server}/test', [\App\Http\Controllers\Admin\ServerController::class, 'testConnection'])->name('servers.test');
    
    // Products Management
    Route::resource('products', \App\Http\Controllers\Admin\ProductController::class);
    
    // Domain Pricing
    Route::resource('domain-pricing', \App\Http\Controllers\Admin\DomainPricingController::class);
    
    // Payment Gateways Management
    Route::resource('gateways', \App\Http\Controllers\Admin\PaymentGatewayController::class);
    Route::post('/gateways/{gateway}/toggle', [\App\Http\Controllers\Admin\PaymentGatewayController::class, 'toggle'])->name('gateways.toggle');
    
    // Email Templates Management
    Route::resource('email-templates', \App\Http\Controllers\Admin\EmailTemplateController::class);
    
    // Module Manager
    Route::prefix('modules')->name('modules.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\ModuleManagerController::class, 'index'])->name('index');
        Route::post('/upload', [\App\Http\Controllers\Admin\ModuleManagerController::class, 'upload'])->name('upload');
        Route::post('/{id}/toggle', [\App\Http\Controllers\Admin\ModuleManagerController::class, 'toggle'])->name('toggle');
        Route::delete('/{id}', [\App\Http\Controllers\Admin\ModuleManagerController::class, 'uninstall'])->name('uninstall');
    });
    
    // Template Manager
    Route::prefix('templates')->name('templates.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\TemplateManagerController::class, 'index'])->name('index');
        Route::post('/upload', [\App\Http\Controllers\Admin\TemplateManagerController::class, 'upload'])->name('upload');
        Route::post('/{id}/activate', [\App\Http\Controllers\Admin\TemplateManagerController::class, 'activate'])->name('activate');
        Route::delete('/{id}', [\App\Http\Controllers\Admin\TemplateManagerController::class, 'uninstall'])->name('uninstall');
    });
    
    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/', [SettingController::class, 'index'])->name('index');
        
        // General Settings
        Route::get('/general', [SettingController::class, 'general'])->name('general');
        Route::post('/general', [SettingController::class, 'updateGeneral'])->name('general.update');
        
        // Email Settings
        Route::get('/email', [SettingController::class, 'email'])->name('email');
        Route::post('/email', [SettingController::class, 'updateEmail'])->name('email.update');
        Route::post('/email/test', [SettingController::class, 'testEmail'])->name('email.test');
        
        // Payment Gateway Settings
        Route::get('/payment', [SettingController::class, 'payment'])->name('payment');
        Route::post('/payment', [SettingController::class, 'updatePayment'])->name('payment.update');
        
        // User & Roles Settings
        Route::get('/users', [SettingController::class, 'users'])->name('users');
        Route::post('/users', [SettingController::class, 'updateUsers'])->name('users.update');
        
        // Product Settings
        Route::get('/products', [SettingController::class, 'products'])->name('products');
        Route::post('/products', [SettingController::class, 'updateProducts'])->name('products.update');
        
        // Automation Settings
        Route::get('/automation', [SettingController::class, 'automation'])->name('automation');
        Route::post('/automation', [SettingController::class, 'updateAutomation'])->name('automation.update');
        
        // Support Settings
        Route::get('/support', [SettingController::class, 'support'])->name('support');
        Route::post('/support', [SettingController::class, 'updateSupport'])->name('support.update');
        
        // API Settings
        Route::get('/api', [SettingController::class, 'api'])->name('api');
        Route::post('/api', [SettingController::class, 'updateApi'])->name('api.update');
        
        // Security Settings
        Route::get('/security', [SettingController::class, 'security'])->name('security');
        Route::post('/security', [SettingController::class, 'updateSecurity'])->name('security.update');
        
        // Module Settings
        Route::get('/modules', [SettingController::class, 'modules'])->name('modules');
        Route::post('/modules', [SettingController::class, 'updateModules'])->name('modules.update');
        
        // Domain Settings
        Route::get('/domains', [SettingController::class, 'domains'])->name('domains');
        Route::post('/domains', [SettingController::class, 'updateDomains'])->name('domains.update');
        
        // Localization Settings
        Route::get('/localization', [SettingController::class, 'localization'])->name('localization');
        Route::post('/localization', [SettingController::class, 'updateLocalization'])->name('localization.update');
        
        // Server Settings
        Route::get('/servers', [SettingController::class, 'servers'])->name('servers');
        Route::post('/servers', [SettingController::class, 'storeServer'])->name('servers.store');
        Route::get('/servers/{server}/edit', [SettingController::class, 'editServer'])->name('servers.edit');
        Route::put('/servers/{server}', [SettingController::class, 'updateServer'])->name('servers.update');
        Route::delete('/servers/{server}', [SettingController::class, 'destroyServer'])->name('servers.destroy');
        Route::post('/servers/test', [SettingController::class, 'testServerConnection'])->name('servers.test');
        Route::post('/servers/{server}/test', [SettingController::class, 'testServerConnection'])->name('servers.test.existing');
    });
});

// Password Reset Routes
Route::get('/forgot-password', [\App\Http\Controllers\Auth\ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('/forgot-password', [\App\Http\Controllers\Auth\ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
Route::get('/reset-password/{token}', [\App\Http\Controllers\Auth\ForgotPasswordController::class, 'showResetForm'])->name('password.reset');
Route::post('/reset-password', [\App\Http\Controllers\Auth\ForgotPasswordController::class, 'reset'])->name('password.update');

// Payment Gateway Webhooks (public endpoints)
Route::post('/webhooks/paypal', [\App\Http\Controllers\WebhookController::class, 'paypal'])->name('webhooks.paypal');
Route::post('/webhooks/stripe', [\App\Http\Controllers\WebhookController::class, 'stripe'])->name('webhooks.stripe');
Route::post('/webhooks/paystack', [\App\Http\Controllers\WebhookController::class, 'paystack'])->name('webhooks.paystack');
Route::post('/webhooks/flutterwave', [\App\Http\Controllers\WebhookController::class, 'flutterwave'])->name('webhooks.flutterwave');
Route::post('/webhooks/razorpay', [\App\Http\Controllers\WebhookController::class, 'razorpay'])->name('webhooks.razorpay');
