@extends('emails.layout')

@section('content')
    <h2>New Invoice Generated</h2>
    
    <p>Hello {{ $invoice->user->name }},</p>
    
    <p>A new invoice has been generated for your account.</p>
    
    <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
        <tr>
            <td><strong>Invoice Number:</strong></td>
            <td>{{ $invoice->invoice_number }}</td>
        </tr>
        <tr>
            <td><strong>Date:</strong></td>
            <td>{{ $invoice->date->format('F d, Y') }}</td>
        </tr>
        <tr>
            <td><strong>Due Date:</strong></td>
            <td>{{ $invoice->due_date->format('F d, Y') }}</td>
        </tr>
        <tr>
            <td><strong>Amount:</strong></td>
            <td>{{ format_currency($invoice->total) }}</td>
        </tr>
    </table>
    
    <p style="text-align: center; margin: 30px 0;">
        <a href="{{ route('client.invoices.show', $invoice) }}" class="button">
            View Invoice
        </a>
    </p>
    
    <p>Thank you for your business!</p>
@endsection
