<div class="hidden lg:flex items-center space-x-1">
    <a href="{{ route('home') }}" class="px-4 py-2 text-sm font-medium text-gray-300 hover:text-white hover:bg-gray-700 rounded-lg transition">
        Home
    </a>
    
    <!-- Hosting Mega Menu -->
    <div class="relative" x-data="{ open: false }">
        <button @click="open = !open" @click.away="open = false" class="px-4 py-2 text-sm font-medium text-gray-300 hover:text-white hover:bg-gray-700 rounded-lg transition flex items-center">
            Hosting
            <svg class="ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
            </svg>
        </button>
        <div x-show="open" x-cloak class="absolute left-0 mt-2 w-72 bg-gray-800 rounded-lg shadow-xl border border-gray-700 z-50">
            <div class="py-2">
                <div class="px-4 py-2 text-xs font-semibold text-gray-400 uppercase tracking-wider">Hosting Services</div>
                @forelse($hostingProducts ?? [] as $product)
                    <a href="{{ route('client.products.show', $product->id) }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                        <div class="font-medium">{{ $product->name }}</div>
                        @if($product->description)
                            <div class="text-xs text-gray-400 mt-0.5">{{ Str::limit($product->description, 50) }}</div>
                        @endif
                    </a>
                @empty
                    <div class="px-4 py-2 text-sm text-gray-400">No hosting products available</div>
                @endforelse
                <div class="border-t border-gray-700 mt-2 pt-2">
                    <a href="{{ route('client.services.index') }}" class="block px-4 py-2 text-sm text-blue-400 hover:bg-gray-700 transition">View My Services</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Reseller Mega Menu -->
    <div class="relative" x-data="{ open: false }">
        <button @click="open = !open" @click.away="open = false" class="px-4 py-2 text-sm font-medium text-gray-300 hover:text-white hover:bg-gray-700 rounded-lg transition flex items-center">
            Reseller
            <svg class="ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
            </svg>
        </button>
        <div x-show="open" x-cloak class="absolute left-0 mt-2 w-72 bg-gray-800 rounded-lg shadow-xl border border-gray-700 z-50">
            <div class="py-2">
                <div class="px-4 py-2 text-xs font-semibold text-gray-400 uppercase tracking-wider">Reseller Plans</div>
                @forelse($resellerProducts ?? [] as $product)
                    <a href="{{ route('client.products.show', $product->id) }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                        <div class="font-medium">{{ $product->name }}</div>
                        @if($product->description)
                            <div class="text-xs text-gray-400 mt-0.5">{{ Str::limit($product->description, 50) }}</div>
                        @endif
                    </a>
                @empty
                    <div class="px-4 py-2 text-sm text-gray-400">No reseller products available</div>
                @endforelse
                <div class="border-t border-gray-700 mt-2 pt-2">
                    <a href="{{ route('client.services.index') }}" class="block px-4 py-2 text-sm text-blue-400 hover:bg-gray-700 transition">View My Services</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Domain Mega Menu -->
    <div class="relative" x-data="{ open: false }">
        <button @click="open = !open" @click.away="open = false" class="px-4 py-2 text-sm font-medium text-gray-300 hover:text-white hover:bg-gray-700 rounded-lg transition flex items-center">
            Domain
            <svg class="ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
            </svg>
        </button>
        <div x-show="open" x-cloak class="absolute left-0 mt-2 w-56 bg-gray-800 rounded-lg shadow-xl border border-gray-700 z-50">
            <div class="py-2">
                <a href="{{ route('client.domains.index') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"></path>
                        </svg>
                        My Domains
                    </div>
                </a>
                <a href="{{ route('client.domains.register') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Register Domain
                    </div>
                </a>
                <a href="{{ route('client.domains.transfer') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                        </svg>
                        Transfer Domain
                    </div>
                </a>
                <a href="{{ route('client.domains.pricing') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Domain Pricing
                    </div>
                </a>
            </div>
        </div>
    </div>

    <!-- Support Mega Menu -->
    <div class="relative" x-data="{ open: false }">
        <button @click="open = !open" @click.away="open = false" class="px-4 py-2 text-sm font-medium text-gray-300 hover:text-white hover:bg-gray-700 rounded-lg transition flex items-center">
            Support
            <svg class="ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
            </svg>
        </button>
        <div x-show="open" x-cloak class="absolute left-0 mt-2 w-56 bg-gray-800 rounded-lg shadow-xl border border-gray-700 z-50">
            <div class="py-2">
                <a href="{{ route('client.tickets.index') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z"></path>
                        </svg>
                        My Support Tickets
                    </div>
                </a>
                <a href="{{ route('client.tickets.create') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Open Ticket
                    </div>
                </a>
                <div class="border-t border-gray-700 my-2"></div>
                <a href="{{ route('client.announcements') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"></path>
                        </svg>
                        Announcements
                    </div>
                </a>
                <a href="{{ route('client.knowledgebase') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                        </svg>
                        Knowledgebase
                    </div>
                </a>
                <a href="{{ route('client.downloads') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10"></path>
                        </svg>
                        Downloads
                    </div>
                </a>
                <a href="{{ route('client.network-status') }}" class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 transition">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                        Network Status
                    </div>
                </a>
            </div>
        </div>
    </div>

    <!-- Contact -->
    <a href="{{ route('client.contact') }}" class="px-4 py-2 text-sm font-medium text-gray-300 hover:text-white hover:bg-gray-700 rounded-lg transition">
        Contact
    </a>
</div>
