@props(['type' => 'info', 'message' => null])

@php
    $styles = [
        'info' => [
            'bg' => 'bg-blue-500/10',
            'border' => 'border-blue-500/50',
            'text' => 'text-blue-400',
        ],
        'error' => [
            'bg' => 'bg-red-500/10',
            'border' => 'border-red-500/50',
            'text' => 'text-red-400',
        ],
    ];
    
    $style = $styles[$type] ?? $styles['info'];
@endphp

<div class="mb-6 p-4 {{ $style['bg'] }} border {{ $style['border'] }} {{ $style['text'] }} rounded-lg backdrop-blur-sm">
    <div class="flex items-start">
        <svg class="w-5 h-5 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true" focusable="false">
            @if($type === 'info')
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
            @else
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
            @endif
        </svg>
        <div class="text-sm flex-1">
            {{ $slot }}
        </div>
    </div>
</div>
