@extends('layouts.app')
@section('title', 'Network Status')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Network Status</h1>
            <p class="text-gray-400">Real-time status of our infrastructure</p>
        </div>

        <!-- Overall Status -->
        <div class="bg-gradient-to-r from-green-600 to-green-700 rounded-xl p-6 mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-2xl font-bold text-white mb-1">All Systems Operational</h2>
                    <p class="text-green-100">Everything is running smoothly</p>
                </div>
                <div class="w-16 h-16 bg-white/20 rounded-full flex items-center justify-center">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Servers -->
        <div class="mb-8">
            <h3 class="text-xl font-bold text-white mb-4">Servers</h3>
            <div class="space-y-4">
                @foreach($servers as $server)
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <h4 class="text-lg font-bold text-white">{{ $server->name }}</h4>
                                <p class="text-gray-400 text-sm">{{ $server->location }}</p>
                            </div>
                            <div class="text-right">
                                <div class="flex items-center space-x-2">
                                    <span class="w-2 h-2 bg-green-500 rounded-full"></span>
                                    <span class="text-green-500 font-medium">{{ ucfirst($server->status) }}</span>
                                </div>
                                <p class="text-gray-400 text-sm mt-1">Uptime: {{ $server->uptime }}</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        <!-- Incidents -->
        @if($incidents->count() > 0)
            <div>
                <h3 class="text-xl font-bold text-white mb-4">Recent Incidents</h3>
                <div class="space-y-4">
                    @foreach($incidents as $incident)
                        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                            <h4 class="text-lg font-bold text-white mb-2">{{ $incident->title }}</h4>
                            <p class="text-gray-400">{{ $incident->description }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>
@endsection