@extends('layouts.app')
@section('title', 'My Invoices')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold mb-6">My Invoices</h1>
    <div class="bg-white shadow rounded-lg p-6">
        @if($invoices->count())
            <table class="min-w-full">
                <thead>
                    <tr class="border-b">
                        <th class="text-left py-2">Invoice #</th>
                        <th class="text-left py-2">Date</th>
                        <th class="text-left py-2">Due Date</th>
                        <th class="text-left py-2">Total</th>
                        <th class="text-left py-2">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($invoices as $invoice)
                    <tr class="border-b">
                        <td class="py-2">{{ $invoice->invoice_number }}</td>
                        <td class="py-2">{{ $invoice->date->format('M d, Y') }}</td>
                        <td class="py-2">{{ $invoice->due_date->format('M d, Y') }}</td>
                        <td class="py-2">{{ format_currency($invoice->total) }}</td>
                        <td class="py-2"><span class="px-2 py-1 text-xs rounded {{ $invoice->status === 'paid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">{{ $invoice->status }}</span></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="text-gray-500">No invoices found</p>
        @endif
    </div>
</div>
@endsection
