@extends('layouts.app')
@section('title', 'Transfer Domain')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <a href="{{ route('client.domains.index') }}" class="text-blue-400 hover:text-blue-300 text-sm mb-4 inline-block">&larr; Back to My Domains</a>
            <h1 class="text-3xl font-bold text-white mb-2">Transfer Domain</h1>
            <p class="text-gray-400">Transfer your domain to us</p>
        </div>

        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            <form class="space-y-6">
                @csrf
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Domain Name</label>
                    <input type="text" name="domain" placeholder="example.com" class="w-full px-4 py-3 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Authorization Code (EPP Code)</label>
                    <input type="text" name="auth_code" placeholder="Enter your EPP code" class="w-full px-4 py-3 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>
                <button type="submit" class="w-full px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">Start Transfer</button>
            </form>
        </div>
    </div>
</div>
@endsection