@extends('layouts.app')
@section('title', 'Contact Us')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Contact Us</h1>
            <p class="text-gray-400">Have a question? We're here to help</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Contact Form -->
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <h2 class="text-xl font-bold text-white mb-4">Send Us a Message</h2>
                <form method="POST" action="{{ route('client.contact.submit') }}" class="space-y-4">
                    @csrf
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Name</label>
                        <input type="text" name="name" value="{{ old('name', auth()->check() ? auth()->user()->name : '') }}" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Email</label>
                        <input type="email" name="email" value="{{ old('email', auth()->check() ? auth()->user()->email : '') }}" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Subject</label>
                        <input type="text" name="subject" value="{{ old('subject') }}" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Message</label>
                        <textarea name="message" rows="4" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">{{ old('message') }}</textarea>
                    </div>
                    <button type="submit" class="w-full px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">Send Message</button>
                </form>
            </div>

            <!-- Contact Info -->
            <div class="space-y-6">
                <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                    <h3 class="text-lg font-bold text-white mb-4">Contact Information</h3>
                    <div class="space-y-4">
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-blue-400 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                            <div>
                                <p class="text-gray-400 text-sm">Email</p>
                                <p class="text-white">support@billingcs.com</p>
                            </div>
                        </div>
                        <div class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-blue-400 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                            </svg>
                            <div>
                                <p class="text-gray-400 text-sm">Phone</p>
                                <p class="text-white">+1 (555) 123-4567</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                    <h3 class="text-lg font-bold text-white mb-4">Support Hours</h3>
                    <p class="text-gray-300">24/7 Support Available</p>
                    <p class="text-gray-400 text-sm mt-2">We're here to help you anytime, anywhere</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection