@extends('layouts.app')
@section('title', 'Shopping Cart')
@section('content')
<div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold text-white mb-8">Shopping Cart</h1>

    @if(session('success'))
        <div class="mb-4 p-4 bg-green-900 border border-green-700 text-green-300 rounded-lg">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="mb-4 p-4 bg-red-900 border border-red-700 text-red-300 rounded-lg">
            {{ session('error') }}
        </div>
    @endif

    @if(empty($cart))
        <div class="bg-gray-800 rounded-lg border border-gray-700 p-12 text-center">
            <svg class="mx-auto h-16 w-16 text-gray-600 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
            </svg>
            <h3 class="text-xl font-semibold text-gray-300 mb-2">Your cart is empty</h3>
            <p class="text-gray-400 mb-6">Browse our products and add items to get started</p>
            <a href="{{ route('home') }}" class="inline-block px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition">
                Browse Products
            </a>
        </div>
    @else
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div class="lg:col-span-2 space-y-4">
                @foreach($cart as $index => $item)
                    <div class="bg-gray-800 rounded-lg border border-gray-700 p-6">
                        <div class="flex justify-between items-start">
                            <div class="flex-1">
                                <h3 class="text-lg font-semibold text-white mb-2">
                                    @if($item['type'] === 'domain')
                                        <span class="text-blue-400">{{ ucfirst($item['action']) }}</span> Domain: {{ $item['domain'] }}
                                    @else
                                        {{ $item['name'] }}
                                    @endif
                                </h3>
                                
                                @if($item['type'] === 'product')
                                    <div class="space-y-1 text-sm text-gray-400">
                                        <p>Billing Cycle: <span class="text-gray-300">{{ ucfirst($item['billing_cycle']) }}</span></p>
                                        @if($item['domain'])
                                            <p>Domain: <span class="text-gray-300">{{ $item['domain'] }}</span></p>
                                        @endif
                                    </div>
                                @endif

                                <div class="mt-4 space-y-1">
                                    <div class="flex justify-between text-sm">
                                        <span class="text-gray-400">Price:</span>
                                        <span class="text-white font-semibold">{{ format_currency($item['price']) }}</span>
                                    </div>
                                    @if($item['setup_fee'] > 0)
                                        <div class="flex justify-between text-sm">
                                            <span class="text-gray-400">Setup Fee:</span>
                                            <span class="text-white font-semibold">{{ format_currency($item['setup_fee']) }}</span>
                                        </div>
                                    @endif
                                    <div class="flex justify-between text-sm font-semibold border-t border-gray-700 pt-2">
                                        <span class="text-gray-300">Subtotal:</span>
                                        <span class="text-white">{{ format_currency($item['price'] + $item['setup_fee']) }}</span>
                                    </div>
                                </div>
                            </div>

                            <form action="{{ route('cart.remove', $index) }}" method="POST" class="ml-4">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-400 hover:text-red-300 p-2" title="Remove">
                                    <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </form>
                        </div>
                    </div>
                @endforeach

                <div class="flex justify-between items-center pt-4">
                    <a href="{{ route('home') }}" class="text-blue-400 hover:text-blue-300">← Continue Shopping</a>
                    <form action="{{ route('cart.clear') }}" method="POST">
                        @csrf
                        <button type="submit" class="text-red-400 hover:text-red-300">Clear Cart</button>
                    </form>
                </div>
            </div>

            <div class="lg:col-span-1">
                <div class="bg-gray-800 rounded-lg border border-gray-700 p-6 sticky top-4">
                    <h3 class="text-lg font-semibold text-white mb-4">Order Summary</h3>
                    
                    <div class="space-y-3 mb-6 pb-6 border-b border-gray-700">
                        <div class="flex justify-between text-gray-400">
                            <span>Items</span>
                            <span>{{ count($cart) }}</span>
                        </div>
                        <div class="flex justify-between text-xl font-bold text-white">
                            <span>Total</span>
                            <span>{{ format_currency($total) }}</span>
                        </div>
                    </div>

                    <form action="{{ route('cart.checkout') }}" method="POST">
                        @csrf
                        
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-300 mb-2">Payment Method</label>
                            <select name="payment_gateway" required
                                class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <option value="paypal">PayPal</option>
                                <option value="stripe">Stripe</option>
                                <option value="bank_transfer">Bank Transfer</option>
                            </select>
                        </div>

                        <button type="submit" class="w-full px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition shadow-lg">
                            Proceed to Checkout
                        </button>
                    </form>

                    <p class="text-xs text-gray-400 mt-4 text-center">
                        By proceeding, you agree to our Terms of Service
                    </p>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
