@extends('layouts.app')
@section('title', 'Security')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Security</h1>
            <p class="text-gray-400">Manage your account security settings</p>
        </div>

        @if(session('success'))
            <div class="bg-green-500/20 border border-green-500 text-green-400 px-4 py-3 rounded-lg mb-6">{{ session('success') }}</div>
        @endif

        <form method="POST" action="{{ route('client.account.security.update') }}" class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            @csrf
            @method('PUT')
            
            <h3 class="text-lg font-bold text-white mb-4">Change Password</h3>

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Current Password</label>
                    <input type="password" name="current_password" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                    @error('current_password')<p class="text-red-400 text-sm mt-1">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">New Password</label>
                    <input type="password" name="password" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                    @error('password')<p class="text-red-400 text-sm mt-1">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Confirm New Password</label>
                    <input type="password" name="password_confirmation" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>
            </div>

            <div class="mt-6 flex justify-end">
                <button type="submit" class="px-6 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">Update Password</button>
            </div>
        </form>
    </div>
</div>
@endsection