@extends('layouts.app')
@section('title', 'Profile')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Profile</h1>
            <p class="text-gray-400">Manage your account information</p>
        </div>

        @if(session('success'))
            <div class="bg-green-500/20 border border-green-500 text-green-400 px-4 py-3 rounded-lg mb-6">{{ session('success') }}</div>
        @endif

        <form method="POST" action="{{ route('client.account.profile.update') }}" class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            @csrf
            @method('PUT')
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Full Name</label>
                    <input type="text" name="name" value="{{ old('name', $user->name) }}" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                    @error('name')<p class="text-red-400 text-sm mt-1">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Email</label>
                    <input type="email" name="email" value="{{ old('email', $user->email) }}" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                    @error('email')<p class="text-red-400 text-sm mt-1">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Company</label>
                    <input type="text" name="company" value="{{ old('company', $user->company) }}" class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Phone</label>
                    <input type="tel" name="phone" value="{{ old('phone', $user->phone) }}" class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>

                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-300 mb-2">Address</label>
                    <textarea name="address" rows="2" class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">{{ old('address', $user->address) }}</textarea>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">City</label>
                    <input type="text" name="city" value="{{ old('city', $user->city) }}" class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">State/Province</label>
                    <input type="text" name="state" value="{{ old('state', $user->state) }}" class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">ZIP/Postal Code</label>
                    <input type="text" name="zip" value="{{ old('zip', $user->zip) }}" class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Country</label>
                    <input type="text" name="country" value="{{ old('country', $user->country) }}" class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                </div>
            </div>

            <div class="mt-6 flex justify-end">
                <button type="submit" class="px-6 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">Update Profile</button>
            </div>
        </form>
    </div>
</div>
@endsection