@extends('layouts.app')
@section('title', 'Account Overview')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Account Overview</h1>
            <p class="text-gray-400">Comprehensive view of your account</p>
        </div>

        <!-- Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Active Services</div>
                <div class="text-3xl font-bold text-white">{{ $stats['active_services'] }}</div>
                <p class="text-gray-500 text-xs mt-1">of {{ $stats['total_services'] }} total</p>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Unpaid Invoices</div>
                <div class="text-3xl font-bold text-yellow-500">{{ $stats['unpaid_invoices'] }}</div>
                <p class="text-gray-500 text-xs mt-1">of {{ $stats['total_invoices'] }} total</p>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Open Tickets</div>
                <div class="text-3xl font-bold text-blue-500">{{ $stats['open_tickets'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Total Spent</div>
                <div class="text-2xl font-bold text-green-500">{{ format_currency($stats['total_spent']) }}</div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Services -->
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <h3 class="text-lg font-bold text-white mb-4">Recent Services</h3>
                <div class="space-y-3">
                    @forelse($recentActivity['services'] as $service)
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-white text-sm">{{ $service->name }}</p>
                                <p class="text-gray-400 text-xs">{{ $service->created_at->diffForHumans() }}</p>
                            </div>
                            <span class="px-2 py-1 bg-green-500/20 text-green-400 rounded text-xs">{{ ucfirst($service->status) }}</span>
                        </div>
                    @empty
                        <p class="text-gray-400 text-sm">No services yet</p>
                    @endforelse
                </div>
            </div>

            <!-- Invoices -->
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <h3 class="text-lg font-bold text-white mb-4">Recent Invoices</h3>
                <div class="space-y-3">
                    @forelse($recentActivity['invoices'] as $invoice)
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-white text-sm">{{ $invoice->invoice_number }}</p>
                                <p class="text-gray-400 text-xs">{{ format_currency($invoice->total) }}</p>
                            </div>
                            <span class="px-2 py-1 bg-{{ $invoice->status === 'paid' ? 'green' : 'yellow' }}-500/20 text-{{ $invoice->status === 'paid' ? 'green' : 'yellow' }}-400 rounded text-xs">{{ ucfirst($invoice->status) }}</span>
                        </div>
                    @empty
                        <p class="text-gray-400 text-sm">No invoices yet</p>
                    @endforelse
                </div>
            </div>

            <!-- Tickets -->
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <h3 class="text-lg font-bold text-white mb-4">Recent Tickets</h3>
                <div class="space-y-3">
                    @forelse($recentActivity['tickets'] as $ticket)
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-white text-sm">{{ Str::limit($ticket->subject, 20) }}</p>
                                <p class="text-gray-400 text-xs">{{ $ticket->created_at->diffForHumans() }}</p>
                            </div>
                            <span class="px-2 py-1 bg-blue-500/20 text-blue-400 rounded text-xs">{{ ucfirst($ticket->status) }}</span>
                        </div>
                    @empty
                        <p class="text-gray-400 text-sm">No tickets yet</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
@endsection