@extends('layouts.app')
@section('title', 'Messages')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Messages</h1>
            <p class="text-gray-400">View your notifications and messages</p>
        </div>

        @forelse($messages as $message)
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 mb-4">
                <h3 class="text-lg font-bold text-white mb-2">{{ $message->title }}</h3>
                <p class="text-gray-300">{{ $message->content }}</p>
            </div>
        @empty
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-12 text-center">
                <svg class="w-16 h-16 mx-auto text-gray-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                </svg>
                <p class="text-gray-400">No messages yet</p>
            </div>
        @endforelse
    </div>
</div>
@endsection