@extends('layouts.app')
@section('title', 'Contacts')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Contacts</h1>
            <p class="text-gray-400">Manage additional contacts for your account</p>
        </div>

        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            <h3 class="text-lg font-bold text-white mb-4">Primary Contact</h3>
            <div class="space-y-2">
                <p class="text-gray-300"><span class="text-gray-400">Name:</span> {{ $user->name }}</p>
                <p class="text-gray-300"><span class="text-gray-400">Email:</span> {{ $user->email }}</p>
                @if($user->phone)
                    <p class="text-gray-300"><span class="text-gray-400">Phone:</span> {{ $user->phone }}</p>
                @endif
            </div>
        </div>

        <div class="mt-6 bg-gray-800 border border-gray-700 rounded-xl p-12 text-center">
            <p class="text-gray-400">Additional contact management feature coming soon</p>
        </div>
    </div>
</div>
@endsection