@extends('layouts.auth')

@section('title', 'Login')

@section('content')
<div class="animate-fade-in-up">
    <!-- Header -->
    <div class="mb-8">
        <h2 class="text-3xl font-bold text-white mb-2">Welcome Back</h2>
        <p class="text-gray-400">Sign in to your client account</p>
    </div>

    <!-- Info Message -->
    @if(session('message'))
        <x-alert type="info">
            <p>{{ session('message') }}</p>
        </x-alert>
    @endif

    <!-- Error Messages -->
    @if($errors->any())
        <x-alert type="error">
            <ul class="space-y-1">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </x-alert>
    @endif

    <!-- Login Form -->
    <form method="POST" action="{{ route('login') }}" class="space-y-6">
        @csrf

        <!-- Email Field -->
        <div class="transform transition-all duration-300 hover:scale-[1.01]">
            <label for="email" class="block text-sm font-medium text-gray-300 mb-2">Email Address</label>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="h-5 w-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"/>
                    </svg>
                </div>
                <input type="email" name="email" id="email" value="{{ old('email') }}" required
                    class="w-full pl-12 pr-4 py-3 bg-gray-800/50 border border-gray-700 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition backdrop-blur-sm"
                    placeholder="you@example.com">
            </div>
        </div>

        <!-- Password Field -->
        <div class="transform transition-all duration-300 hover:scale-[1.01]">
            <label for="password" class="block text-sm font-medium text-gray-300 mb-2">Password</label>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="h-5 w-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                    </svg>
                </div>
                <input type="password" name="password" id="password" required
                    class="w-full pl-12 pr-4 py-3 bg-gray-800/50 border border-gray-700 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition backdrop-blur-sm"
                    placeholder="••••••••">
            </div>
        </div>

        <!-- Remember Me & Forgot Password -->
        <div class="flex items-center justify-between">
            <label class="flex items-center group cursor-pointer">
                <input type="checkbox" name="remember" class="rounded border-gray-600 bg-gray-800 text-blue-600 focus:ring-blue-500 focus:ring-offset-gray-900">
                <span class="ml-2 text-sm text-gray-400 group-hover:text-gray-300 transition">Remember me</span>
            </label>
            <a href="{{ route('password.request') }}" class="text-sm text-blue-400 hover:text-blue-300 transition">
                Forgot password?
            </a>
        </div>

        <!-- Submit Button -->
        <button type="submit" 
            class="w-full bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold py-3 px-4 rounded-lg transition duration-300 transform hover:scale-[1.02] hover:shadow-xl hover:shadow-blue-500/50 flex items-center justify-center space-x-2">
            <span>Sign In</span>
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/>
            </svg>
        </button>

        <!-- Register Link -->
        @if(config('app.enable_registration'))
            <div class="text-center pt-4 border-t border-gray-800">
                <p class="text-sm text-gray-400">
                    Don't have an account? 
                    <a href="{{ route('register') }}" class="text-blue-400 hover:text-blue-300 font-medium transition">
                        Create one now
                    </a>
                </p>
            </div>
        @endif

        <!-- Admin Login Link -->
        <div class="text-center pt-2">
            <p class="text-sm text-gray-500">
                Administrator? 
                <a href="{{ route('admin.login') }}" class="text-gray-400 hover:text-gray-300 font-medium transition">
                    Sign in here
                </a>
            </p>
        </div>
    </form>
</div>
@endsection
