@extends('layouts.app')
@section('title', 'Support Overview')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Support Overview</h1>
            <p class="text-gray-400">Overview of support tickets and statistics</p>
        </div>
        
        <!-- Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Total Tickets</div>
                <div class="text-3xl font-bold text-white">{{ $stats['total_tickets'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Open</div>
                <div class="text-3xl font-bold text-blue-500">{{ $stats['open_tickets'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Answered</div>
                <div class="text-3xl font-bold text-green-500">{{ $stats['answered_tickets'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Closed</div>
                <div class="text-3xl font-bold text-gray-500">{{ $stats['closed_tickets'] }}</div>
            </div>
        </div>

        <!-- Recent Tickets -->
        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            <h2 class="text-xl font-bold text-white mb-4">Recent Tickets</h2>
            <div class="space-y-4">
                @forelse($recent_tickets as $ticket)
                    <div class="flex items-center justify-between p-4 bg-gray-900 rounded-lg">
                        <div>
                            <div class="text-white font-medium">{{ $ticket->subject }}</div>
                            <div class="text-sm text-gray-400">{{ $ticket->user->name }} - {{ $ticket->updated_at->diffForHumans() }}</div>
                        </div>
                        <span class="px-3 py-1 bg-blue-500/20 text-blue-400 rounded text-sm">{{ ucfirst($ticket->status) }}</span>
                    </div>
                @empty
                    <p class="text-center text-gray-400 py-8">No tickets yet</p>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection