@extends('layouts.app')

@section('title', 'Admin Settings')

@section('content')
<div class="min-h-screen bg-gray-900">
    <div class="flex">
        <!-- Sidebar Filter -->
        <aside class="hidden lg:block w-64 bg-gray-800 border-r border-gray-700 min-h-screen" x-data="{ activeCategory: 'all' }">
            <div class="p-6">
                <h2 class="text-sm font-semibold text-gray-400 uppercase tracking-wider mb-4">Settings Categories</h2>
                <nav class="space-y-2">
                    <button @click="activeCategory = 'all'" 
                            :class="activeCategory === 'all' ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700'"
                            class="w-full flex items-center px-3 py-2 text-sm rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                        </svg>
                        All Settings
                    </button>
                    
                    <button @click="activeCategory = 'system'" 
                            :class="activeCategory === 'system' ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700'"
                            class="w-full flex items-center px-3 py-2 text-sm rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        System
                    </button>
                    
                    <button @click="activeCategory = 'apps'" 
                            :class="activeCategory === 'apps' ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700'"
                            class="w-full flex items-center px-3 py-2 text-sm rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                        </svg>
                        Apps & Integrations
                    </button>
                    
                    <button @click="activeCategory = 'users'" 
                            :class="activeCategory === 'users' ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700'"
                            class="w-full flex items-center px-3 py-2 text-sm rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                        User Management
                    </button>
                    
                    <button @click="activeCategory = 'products'" 
                            :class="activeCategory === 'products' ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700'"
                            class="w-full flex items-center px-3 py-2 text-sm rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                        </svg>
                        Products & Services
                    </button>
                    
                    <button @click="activeCategory = 'support'" 
                            :class="activeCategory === 'support' ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700'"
                            class="w-full flex items-center px-3 py-2 text-sm rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                        Support
                    </button>
                    
                    <button @click="activeCategory = 'security'" 
                            :class="activeCategory === 'security' ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700'"
                            class="w-full flex items-center px-3 py-2 text-sm rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                        API & Security
                    </button>
                </nav>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 p-6 lg:p-8" x-data="settingsData()">
            <div class="max-w-7xl mx-auto">
                <!-- Header -->
                <div class="mb-8">
                    <h1 class="text-3xl font-bold text-white mb-2">Admin Settings</h1>
                    <p class="text-gray-400">Configure and manage all system settings</p>
                </div>

                <!-- Search Bar -->
                <div class="mb-8">
                    <div class="relative">
                        <input type="text" 
                               x-model="searchQuery"
                               placeholder="Search settings..." 
                               class="w-full px-4 py-3 pl-12 bg-gray-800 border border-gray-700 rounded-lg text-white placeholder-gray-400 focus:outline-none focus:border-blue-500 focus:ring-1 focus:ring-blue-500">
                        <svg class="absolute left-4 top-3.5 w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                </div>

                <!-- Settings Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <!-- General Settings Card -->
                    <template x-if="shouldShowCard('general', 'system')">
                        <a href="{{ route('admin.settings.general') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-blue-500/10 rounded-lg flex items-center justify-center group-hover:bg-blue-500/20 transition">
                                    <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-blue-400 transition">General Settings</h3>
                            <p class="text-sm text-gray-400">Configure site name, currency, tax rates, and basic system settings</p>
                        </a>
                    </template>

                    <!-- Email Settings Card -->
                    <template x-if="shouldShowCard('email', 'system')">
                        <a href="{{ route('admin.settings.email') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-purple-500/10 rounded-lg flex items-center justify-center group-hover:bg-purple-500/20 transition">
                                    <svg class="w-6 h-6 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-purple-400 transition">Email Settings</h3>
                            <p class="text-sm text-gray-400">Configure SMTP server, email templates, and notification settings</p>
                        </a>
                    </template>

                    <!-- Payment Gateway Settings Card -->
                    <template x-if="shouldShowCard('payment', 'apps')">
                        <a href="{{ route('admin.settings.payment') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-green-500/10 rounded-lg flex items-center justify-center group-hover:bg-green-500/20 transition">
                                    <svg class="w-6 h-6 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-green-400 transition">Payment Gateways</h3>
                            <p class="text-sm text-gray-400">Manage payment processors, API keys, and transaction settings</p>
                        </a>
                    </template>

                    <!-- User & Roles Card -->
                    <template x-if="shouldShowCard('user roles', 'users')">
                        <a href="{{ route('admin.settings.users') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-yellow-500/10 rounded-lg flex items-center justify-center group-hover:bg-yellow-500/20 transition">
                                    <svg class="w-6 h-6 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-yellow-400 transition">User & Roles</h3>
                            <p class="text-sm text-gray-400">Manage user permissions, roles, and access control settings</p>
                        </a>
                    </template>

                    <!-- Product Settings Card -->
                    <template x-if="shouldShowCard('product', 'products')">
                        <a href="{{ route('admin.settings.products') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-indigo-500/10 rounded-lg flex items-center justify-center group-hover:bg-indigo-500/20 transition">
                                    <svg class="w-6 h-6 text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-indigo-400 transition">Product Settings</h3>
                            <p class="text-sm text-gray-400">Configure product options, pricing tiers, and service features</p>
                        </a>
                    </template>

                    <!-- Automation Settings Card -->
                    <template x-if="shouldShowCard('automation', 'system')">
                        <a href="{{ route('admin.settings.automation') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-pink-500/10 rounded-lg flex items-center justify-center group-hover:bg-pink-500/20 transition">
                                    <svg class="w-6 h-6 text-pink-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-pink-400 transition">Automation Settings</h3>
                            <p class="text-sm text-gray-400">Configure cron jobs, automated tasks, and scheduled processes</p>
                        </a>
                    </template>

                    <!-- Support Settings Card -->
                    <template x-if="shouldShowCard('support', 'support')">
                        <a href="{{ route('admin.settings.support') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-red-500/10 rounded-lg flex items-center justify-center group-hover:bg-red-500/20 transition">
                                    <svg class="w-6 h-6 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-red-400 transition">Support Settings</h3>
                            <p class="text-sm text-gray-400">Configure ticket departments, priorities, and support workflows</p>
                        </a>
                    </template>

                    <!-- API Settings Card -->
                    <template x-if="shouldShowCard('api', 'security')">
                        <a href="{{ route('admin.settings.api') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-cyan-500/10 rounded-lg flex items-center justify-center group-hover:bg-cyan-500/20 transition">
                                    <svg class="w-6 h-6 text-cyan-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-cyan-400 transition">API Settings</h3>
                            <p class="text-sm text-gray-400">Manage API keys, access tokens, and integration settings</p>
                        </a>
                    </template>

                    <!-- Security Settings Card -->
                    <template x-if="shouldShowCard('security', 'security')">
                        <a href="{{ route('admin.settings.security') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-orange-500/10 rounded-lg flex items-center justify-center group-hover:bg-orange-500/20 transition">
                                    <svg class="w-6 h-6 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-orange-400 transition">Security Settings</h3>
                            <p class="text-sm text-gray-400">Configure authentication, two-factor auth, and security policies</p>
                        </a>
                    </template>

                    <!-- Module Settings Card -->
                    <template x-if="shouldShowCard('module', 'apps')">
                        <a href="{{ route('admin.settings.modules') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-teal-500/10 rounded-lg flex items-center justify-center group-hover:bg-teal-500/20 transition">
                                    <svg class="w-6 h-6 text-teal-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-teal-400 transition">Module Settings</h3>
                            <p class="text-sm text-gray-400">Configure server modules, provisioning, and integration modules</p>
                        </a>
                    </template>

                    <!-- Domain Settings Card -->
                    <template x-if="shouldShowCard('domain', 'products')">
                        <a href="{{ route('admin.settings.domains') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-lime-500/10 rounded-lg flex items-center justify-center group-hover:bg-lime-500/20 transition">
                                    <svg class="w-6 h-6 text-lime-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-lime-400 transition">Domain Settings</h3>
                            <p class="text-sm text-gray-400">Configure domain registrars, TLD pricing, and WHOIS settings</p>
                        </a>
                    </template>

                    <!-- Localization Settings Card -->
                    <template x-if="shouldShowCard('localization', 'system')">
                        <a href="{{ route('admin.settings.localization') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-violet-500/10 rounded-lg flex items-center justify-center group-hover:bg-violet-500/20 transition">
                                    <svg class="w-6 h-6 text-violet-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-violet-400 transition">Localization</h3>
                            <p class="text-sm text-gray-400">Configure languages, timezones, date formats, and regional settings</p>
                        </a>
                    </template>

                    <!-- Server Settings Card -->
                    <template x-if="shouldShowCard('server', 'system')">
                        <a href="{{ route('admin.settings.servers') }}" 
                           class="group bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-1 hover:shadow-2xl hover:shadow-blue-500/20">
                            <div class="flex items-center mb-4">
                                <div class="w-12 h-12 bg-emerald-500/10 rounded-lg flex items-center justify-center group-hover:bg-emerald-500/20 transition">
                                    <svg class="w-6 h-6 text-emerald-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"></path>
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-white mb-2 group-hover:text-emerald-400 transition">Server Management</h3>
                            <p class="text-sm text-gray-400">Configure hosting servers, test connections, and manage provisioning</p>
                        </a>
                    </template>
                </div>

                <!-- Empty State -->
                <div x-show="filteredCardsCount === 0" class="text-center py-12">
                    <svg class="w-16 h-16 text-gray-600 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-400 mb-2">No settings found</h3>
                    <p class="text-gray-500">Try adjusting your search or filter</p>
                </div>
            </div>
        </main>
    </div>
</div>

<script>
function settingsData() {
    return {
        searchQuery: '',
        activeCategory: 'all',
        cards: [
            { name: 'general', category: 'system', keywords: 'general site name currency tax basic' },
            { name: 'email', category: 'system', keywords: 'email smtp mail notification templates' },
            { name: 'payment', category: 'apps', keywords: 'payment gateway processor stripe paypal transaction' },
            { name: 'user roles', category: 'users', keywords: 'user roles permissions access control admin' },
            { name: 'product', category: 'products', keywords: 'product pricing service features tiers' },
            { name: 'automation', category: 'system', keywords: 'automation cron jobs scheduled tasks' },
            { name: 'support', category: 'support', keywords: 'support ticket department priority workflow' },
            { name: 'api', category: 'security', keywords: 'api key token integration webhook' },
            { name: 'security', category: 'security', keywords: 'security authentication 2fa two factor password' },
            { name: 'module', category: 'apps', keywords: 'module server provisioning integration cpanel' },
            { name: 'domain', category: 'products', keywords: 'domain registrar tld whois dns' },
            { name: 'localization', category: 'system', keywords: 'localization language timezone date format region' },
            { name: 'server', category: 'system', keywords: 'server hosting cpanel whm directadmin plesk provisioning' }
        ],
        shouldShowCard(cardName, cardCategory) {
            const query = this.searchQuery.toLowerCase();
            const card = this.cards.find(c => c.name === cardName);
            
            if (!card) return false;
            
            // Filter by category
            if (this.activeCategory !== 'all' && card.category !== this.activeCategory) {
                return false;
            }
            
            // Filter by search
            if (query && !card.keywords.includes(query) && !card.name.includes(query)) {
                return false;
            }
            
            return true;
        },
        get filteredCardsCount() {
            return this.cards.filter(card => this.shouldShowCard(card.name, card.category)).length;
        }
    }
}

// Make activeCategory globally accessible for sidebar
document.addEventListener('alpine:init', () => {
    Alpine.store('settings', {
        activeCategory: 'all'
    });
});
</script>

@endsection
