@extends('layouts.app')

@section('title', 'Edit Server')

@section('content')
<div class="min-h-screen bg-gray-900 p-6" x-data="editServerManagement()">
    <div class="max-w-4xl mx-auto">
        <!-- Breadcrumb -->
        <nav class="flex mb-6" aria-label="Breadcrumb">
            <ol class="inline-flex items-center space-x-1 md:space-x-3">
                <li class="inline-flex items-center">
                    <a href="{{ route('admin.dashboard') }}" class="text-gray-400 hover:text-white">Admin</a>
                </li>
                <li>
                    <div class="flex items-center">
                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <a href="{{ route('admin.settings.index') }}" class="ml-1 text-gray-400 hover:text-white">Settings</a>
                    </div>
                </li>
                <li>
                    <div class="flex items-center">
                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <a href="{{ route('admin.settings.servers') }}" class="ml-1 text-gray-400 hover:text-white">Server Settings</a>
                    </div>
                </li>
                <li aria-current="page">
                    <div class="flex items-center">
                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="ml-1 text-gray-500">Edit Server</span>
                    </div>
                </li>
            </ol>
        </nav>

        <!-- Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Edit Server</h1>
            <p class="text-gray-400">Update server configuration and credentials</p>
        </div>

        <div class="bg-gray-800 border border-gray-700 rounded-xl shadow-2xl p-6">
            <form action="{{ route('admin.settings.servers.update', $server) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Server Name -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Server Name *</label>
                        <input type="text" name="name" value="{{ old('name', $server->name) }}" required
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('name')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <!-- Server Type -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Server Type *</label>
                        <select name="type" required x-model="serverType"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="cpanel" {{ $server->type === 'cpanel' ? 'selected' : '' }}>cPanel/WHM</option>
                            <option value="directadmin" {{ $server->type === 'directadmin' ? 'selected' : '' }}>DirectAdmin</option>
                            <option value="plesk" {{ $server->type === 'plesk' ? 'selected' : '' }}>Plesk</option>
                            <option value="custom" {{ $server->type === 'custom' ? 'selected' : '' }}>Custom</option>
                        </select>
                        @error('type')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <!-- Hostname -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Hostname *</label>
                        <input type="text" name="hostname" value="{{ old('hostname', $server->hostname) }}" required
                            x-model="hostname"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('hostname')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <!-- IP Address -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">IP Address *</label>
                        <input type="text" name="ip_address" value="{{ old('ip_address', $server->ip_address) }}" required
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('ip_address')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <!-- Username -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Username *</label>
                        <input type="text" name="username" value="{{ old('username', $server->username) }}" required
                            x-model="username"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('username')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <!-- Password -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Password</label>
                        <div class="relative">
                            <input :type="showPassword ? 'text' : 'password'" name="password"
                                x-model="password"
                                class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500 pr-10"
                                placeholder="Leave blank to keep current password">
                            <button type="button" @click="showPassword = !showPassword" 
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-white">
                                <svg x-show="!showPassword" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                </svg>
                                <svg x-show="showPassword" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                                </svg>
                            </button>
                        </div>
                        @error('password')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                        <p class="mt-1 text-xs text-gray-400">Leave blank to keep the existing password</p>
                    </div>

                    <!-- Port -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Port *</label>
                        <input type="number" name="port" value="{{ old('port', $server->port) }}" required
                            x-model="port"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('port')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <!-- Max Accounts -->
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Max Accounts</label>
                        <input type="number" name="max_accounts" value="{{ old('max_accounts', $server->max_accounts) }}" min="0"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('max_accounts')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>
                </div>

                <!-- Nameservers -->
                <div class="mt-6">
                    <h3 class="text-lg font-semibold text-white mb-4">Nameservers</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Nameserver 1</label>
                            <input type="text" name="nameserver1" value="{{ old('nameserver1', $server->nameserver1) }}"
                                class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Nameserver 2</label>
                            <input type="text" name="nameserver2" value="{{ old('nameserver2', $server->nameserver2) }}"
                                class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Nameserver 3</label>
                            <input type="text" name="nameserver3" value="{{ old('nameserver3', $server->nameserver3) }}"
                                class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Nameserver 4</label>
                            <input type="text" name="nameserver4" value="{{ old('nameserver4', $server->nameserver4) }}"
                                class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        </div>
                    </div>
                </div>

                <!-- Notes -->
                <div class="mt-6">
                    <label class="block text-sm font-medium text-gray-300 mb-2">Notes</label>
                    <textarea name="notes" rows="3"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('notes', $server->notes) }}</textarea>
                </div>

                <!-- Options -->
                <div class="mt-6 flex items-center space-x-6">
                    <label class="flex items-center">
                        <input type="checkbox" name="secure" value="1" {{ old('secure', $server->secure) ? 'checked' : '' }}
                            class="w-4 h-4 bg-gray-900 border-gray-700 rounded text-blue-600 focus:ring-blue-500 focus:ring-2">
                        <span class="ml-2 text-sm text-gray-300">Use HTTPS</span>
                    </label>

                    <label class="flex items-center">
                        <input type="checkbox" name="active" value="1" {{ old('active', $server->active) ? 'checked' : '' }}
                            class="w-4 h-4 bg-gray-900 border-gray-700 rounded text-blue-600 focus:ring-blue-500 focus:ring-2">
                        <span class="ml-2 text-sm text-gray-300">Active</span>
                    </label>
                </div>

                <!-- Test Connection Result -->
                <div x-show="testResult.show" 
                     :class="testResult.success ? 'bg-green-500/10 border-green-500 text-green-400' : 'bg-red-500/10 border-red-500 text-red-400'"
                     class="mt-6 p-4 border rounded-lg">
                    <div class="flex items-center">
                        <svg x-show="testResult.success" class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <svg x-show="!testResult.success" class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                        <span x-text="testResult.message"></span>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="mt-8 flex items-center justify-between">
                    <button type="button" @click="testConnection({{ $server->id }})" :disabled="testing"
                        class="px-6 py-3 bg-yellow-600 hover:bg-yellow-700 text-white font-semibold rounded-lg transition flex items-center disabled:opacity-50 disabled:cursor-not-allowed">
                        <svg x-show="!testing" class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                        <svg x-show="testing" class="animate-spin w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                        </svg>
                        <span x-text="testing ? 'Testing...' : 'Test Connection'"></span>
                    </button>

                    <div class="flex space-x-4">
                        <a href="{{ route('admin.settings.servers') }}" 
                            class="px-6 py-3 bg-gray-700 hover:bg-gray-600 text-white font-semibold rounded-lg transition">
                            Cancel
                        </a>
                        <button type="submit"
                            class="px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition shadow-lg flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            Update Server
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editServerManagement() {
    return {
        showPassword: false,
        testing: false,
        testResult: {
            show: false,
            success: false,
            message: ''
        },
        serverType: '{{ $server->type }}',
        hostname: '{{ $server->hostname }}',
        username: '{{ $server->username }}',
        password: '',
        port: {{ $server->port }},

        async testConnection(serverId) {
            this.testing = true;
            this.testResult.show = false;

            try {
                const response = await fetch(`/admin/settings/servers/${serverId}/test`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });

                const data = await response.json();
                
                this.testResult = {
                    show: true,
                    success: data.success,
                    message: data.message
                };
            } catch (error) {
                this.testResult = {
                    show: true,
                    success: false,
                    message: 'Connection test failed: ' + error.message
                };
            } finally {
                this.testing = false;
            }
        }
    }
}
</script>
@endsection
