@extends('layouts.app')
@section('title', 'Services')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold mb-6">Services Management</h1>
    <div class="bg-white shadow rounded-lg p-6">
        <table class="min-w-full">
            <thead>
                <tr class="border-b">
                    <th class="text-left py-2">Service</th>
                    <th class="text-left py-2">User</th>
                    <th class="text-left py-2">Type</th>
                    <th class="text-left py-2">Price</th>
                    <th class="text-left py-2">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($services as $service)
                <tr class="border-b">
                    <td class="py-2">{{ $service->name }}</td>
                    <td class="py-2">{{ $service->user->name }}</td>
                    <td class="py-2">{{ $service->type }}</td>
                    <td class="py-2">{{ format_currency($service->price) }}</td>
                    <td class="py-2"><span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800">{{ $service->status }}</span></td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
