@extends('layouts.app')
@section('title', 'Add Server')
@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <a href="{{ route('admin.servers.index') }}" class="text-blue-400 hover:text-blue-300">&larr; Back to Servers</a>
    </div>

    <div class="bg-gray-800 shadow rounded-lg border border-gray-700 p-8">
        <h1 class="text-2xl font-bold text-white mb-6">Add New Server</h1>

        <form action="{{ route('admin.servers.store') }}" method="POST">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Server Name *</label>
                    <input type="text" name="name" value="{{ old('name') }}" required
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('name')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Server Type *</label>
                    <select name="type" required
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="cpanel">cPanel/WHM</option>
                        <option value="directadmin">DirectAdmin</option>
                        <option value="plesk">Plesk</option>
                        <option value="custom">Custom</option>
                    </select>
                    @error('type')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Hostname *</label>
                    <input type="text" name="hostname" value="{{ old('hostname') }}" required
                        placeholder="server1.example.com"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('hostname')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">IP Address *</label>
                    <input type="text" name="ip_address" value="{{ old('ip_address') }}" required
                        placeholder="192.168.1.1"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('ip_address')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Username *</label>
                    <input type="text" name="username" value="{{ old('username') }}" required
                        placeholder="root"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('username')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Password *</label>
                    <input type="password" name="password" required
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('password')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Port *</label>
                    <input type="number" name="port" value="{{ old('port', 2087) }}" required
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('port')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Max Accounts</label>
                    <input type="number" name="max_accounts" value="{{ old('max_accounts', 0) }}"
                        placeholder="0 for unlimited"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('max_accounts')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Nameserver 1</label>
                    <input type="text" name="nameserver1" value="{{ old('nameserver1') }}"
                        placeholder="ns1.example.com"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Nameserver 2</label>
                    <input type="text" name="nameserver2" value="{{ old('nameserver2') }}"
                        placeholder="ns2.example.com"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Nameserver 3</label>
                    <input type="text" name="nameserver3" value="{{ old('nameserver3') }}"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Nameserver 4</label>
                    <input type="text" name="nameserver4" value="{{ old('nameserver4') }}"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
            </div>

            <div class="mt-6">
                <label class="block text-sm font-medium text-gray-300 mb-2">Notes</label>
                <textarea name="notes" rows="3"
                    class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('notes') }}</textarea>
            </div>

            <div class="mt-6 flex items-center space-x-6">
                <label class="flex items-center">
                    <input type="checkbox" name="secure" value="1" checked
                        class="rounded border-gray-700 text-blue-600 bg-gray-900 focus:ring-blue-500">
                    <span class="ml-2 text-sm text-gray-300">Use HTTPS</span>
                </label>

                <label class="flex items-center">
                    <input type="checkbox" name="active" value="1" checked
                        class="rounded border-gray-700 text-blue-600 bg-gray-900 focus:ring-blue-500">
                    <span class="ml-2 text-sm text-gray-300">Active</span>
                </label>
            </div>

            <div class="mt-8 flex space-x-4">
                <button type="submit" class="px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition shadow-lg">
                    Add Server
                </button>
                <a href="{{ route('admin.servers.index') }}" class="px-6 py-3 bg-gray-700 hover:bg-gray-600 text-white font-semibold rounded-lg transition">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
