@extends('layouts.app')
@section('title', 'New Order')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Create New Order</h1>
            <p class="text-gray-400">Create a new service order for a client</p>
        </div>
        <form method="POST" action="{{ route('admin.new.order.store') }}" class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            @csrf
            <div class="space-y-6">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Select Client *</label>
                    <select name="user_id" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                        <option value="">Choose a client...</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}">{{ $client->name }} ({{ $client->email }})</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Select Product *</label>
                    <select name="product_id" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                        <option value="">Choose a product...</option>
                        @foreach($products as $product)
                            <option value="{{ $product->id }}">{{ $product->name }} - {{ $product->type }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Billing Cycle *</label>
                    <select name="billing_cycle" required class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white">
                        <option value="monthly">Monthly</option>
                        <option value="quarterly">Quarterly</option>
                        <option value="semi-annually">Semi-Annually</option>
                        <option value="annually">Annually</option>
                    </select>
                </div>
            </div>
            <div class="mt-8 flex justify-end space-x-4">
                <a href="{{ route('admin.orders.index') }}" class="px-6 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-lg">Cancel</a>
                <button type="submit" class="px-6 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">Create Order</button>
            </div>
        </form>
    </div>
</div>
@endsection