@extends('layouts.app')
@section('title', 'Edit Domain Pricing')
@section('content')
<div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <a href="{{ route('admin.domain-pricing.index') }}" class="text-blue-400 hover:text-blue-300">&larr; Back to Domain Pricing</a>
    </div>

    <div class="bg-gray-800 shadow rounded-lg border border-gray-700 p-8">
        <h1 class="text-2xl font-bold text-white mb-6">Edit Domain TLD</h1>

        <form action="{{ route('admin.domain-pricing.update', $domainPricing) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="space-y-6">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Extension *</label>
                    <input type="text" name="extension" value="{{ old('extension', $domainPricing->extension) }}" required
                        placeholder=".com"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <p class="mt-1 text-sm text-gray-400">Include the dot (e.g., .com, .net, .org)</p>
                    @error('extension')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Register Price *</label>
                        <input type="number" step="0.01" name="register_price" value="{{ old('register_price', $domainPricing->register_price) }}" required
                            placeholder="9.99"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('register_price')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Renew Price *</label>
                        <input type="number" step="0.01" name="renew_price" value="{{ old('renew_price', $domainPricing->renew_price) }}" required
                            placeholder="12.99"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('renew_price')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Transfer Price *</label>
                        <input type="number" step="0.01" name="transfer_price" value="{{ old('transfer_price', $domainPricing->transfer_price) }}" required
                            placeholder="9.99"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        @error('transfer_price')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="active" value="1" {{ $domainPricing->active ? 'checked' : '' }}
                            class="rounded border-gray-700 text-blue-600 bg-gray-900 focus:ring-blue-500">
                        <span class="ml-2 text-sm text-gray-300">Active</span>
                    </label>
                </div>
            </div>

            <div class="mt-8 flex space-x-4">
                <button type="submit" class="px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition shadow-lg">
                    Update Domain TLD
                </button>
                <a href="{{ route('admin.domain-pricing.index') }}" class="px-6 py-3 bg-gray-700 hover:bg-gray-600 text-white font-semibold rounded-lg transition">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
