@extends('layouts.app')

@section('title', 'Transactions List')

@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Transaction List</h1>
            <p class="text-gray-400">View all payment transactions</p>
        </div>

        <!-- Filters -->
        <div class="mb-6 flex gap-4">
            <a href="{{ route('admin.billing.transactions') }}" class="px-4 py-2 {{ !request('status') ? 'bg-blue-600' : 'bg-gray-700' }} hover:bg-blue-700 text-white rounded-lg transition">All</a>
            <a href="{{ route('admin.billing.transactions', ['status' => 'completed']) }}" class="px-4 py-2 {{ request('status') === 'completed' ? 'bg-blue-600' : 'bg-gray-700' }} hover:bg-blue-700 text-white rounded-lg transition">Completed</a>
            <a href="{{ route('admin.billing.transactions', ['status' => 'pending']) }}" class="px-4 py-2 {{ request('status') === 'pending' ? 'bg-blue-600' : 'bg-gray-700' }} hover:bg-blue-700 text-white rounded-lg transition">Pending</a>
            <a href="{{ route('admin.billing.transactions', ['status' => 'failed']) }}" class="px-4 py-2 {{ request('status') === 'failed' ? 'bg-blue-600' : 'bg-gray-700' }} hover:bg-blue-700 text-white rounded-lg transition">Failed</a>
        </div>

        <!-- Transactions Table -->
        <div class="bg-gray-800 border border-gray-700 rounded-xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-750">
                        <tr>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Transaction ID</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Client</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Invoice</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Gateway</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Amount</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Status</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Date</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-700">
                        @forelse($transactions as $transaction)
                            <tr class="hover:bg-gray-750 transition">
                                <td class="px-6 py-4 text-gray-300 font-mono text-sm">{{ $transaction->transaction_id }}</td>
                                <td class="px-6 py-4">
                                    <div class="text-white font-medium">{{ $transaction->user->name }}</div>
                                    <div class="text-sm text-gray-400">{{ $transaction->user->email }}</div>
                                </td>
                                <td class="px-6 py-4 text-gray-300">
                                    @if($transaction->invoice)
                                        <a href="{{ route('admin.invoices.show', $transaction->invoice_id) }}" class="text-blue-400 hover:text-blue-300">
                                            {{ $transaction->invoice->invoice_number }}
                                        </a>
                                    @else
                                        <span class="text-gray-500">N/A</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-gray-300 uppercase">{{ $transaction->gateway }}</td>
                                <td class="px-6 py-4 text-white font-semibold">{{ format_currency($transaction->amount) }}</td>
                                <td class="px-6 py-4">
                                    @if($transaction->status === 'completed')
                                        <span class="px-2 py-1 bg-green-500/20 text-green-400 rounded text-sm">Completed</span>
                                    @elseif($transaction->status === 'pending')
                                        <span class="px-2 py-1 bg-yellow-500/20 text-yellow-400 rounded text-sm">Pending</span>
                                    @elseif($transaction->status === 'failed')
                                        <span class="px-2 py-1 bg-red-500/20 text-red-400 rounded text-sm">Failed</span>
                                    @else
                                        <span class="px-2 py-1 bg-gray-500/20 text-gray-400 rounded text-sm">{{ ucfirst($transaction->status) }}</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-gray-400 text-sm">{{ $transaction->created_at->format('M d, Y H:i') }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-6 py-12 text-center text-gray-400">No transactions found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($transactions->hasPages())
                <div class="px-6 py-4 border-t border-gray-700">
                    {{ $transactions->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection