@extends('layouts.app')
@section('title', 'Quotes')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8 flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-white mb-2">Manage Quotes</h1>
                <p class="text-gray-400">View and manage quotes</p>
            </div>
            <a href="{{ route('admin.new.quote') }}" class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">New Quote</a>
        </div>

        <!-- Stats -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Total Quotes</div>
                <div class="text-3xl font-bold text-white">{{ $stats['total_quotes'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Pending</div>
                <div class="text-3xl font-bold text-yellow-500">{{ $stats['pending_quotes'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Accepted</div>
                <div class="text-3xl font-bold text-green-500">{{ $stats['accepted_quotes'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Total Value</div>
                <div class="text-2xl font-bold text-white">{{ format_currency($stats['total_value']) }}</div>
            </div>
        </div>

        <!-- Quotes Table -->
        <div class="bg-gray-800 border border-gray-700 rounded-xl overflow-hidden">
            <table class="w-full">
                <thead class="bg-gray-750">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Quote #</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Client</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Subject</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Amount</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Status</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Date</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($quotes as $quote)
                        <tr class="hover:bg-gray-750">
                            <td class="px-6 py-4 text-gray-300">{{ $quote->quote_number }}</td>
                            <td class="px-6 py-4 text-white">{{ $quote->user->name }}</td>
                            <td class="px-6 py-4 text-gray-300">{{ $quote->subject }}</td>
                            <td class="px-6 py-4 text-white font-semibold">{{ format_currency($quote->total) }}</td>
                            <td class="px-6 py-4">
                                @if($quote->status === 'accepted')
                                    <span class="px-2 py-1 bg-green-500/20 text-green-400 rounded text-sm">Accepted</span>
                                @elseif($quote->status === 'pending')
                                    <span class="px-2 py-1 bg-yellow-500/20 text-yellow-400 rounded text-sm">Pending</span>
                                @else
                                    <span class="px-2 py-1 bg-gray-500/20 text-gray-400 rounded text-sm">{{ ucfirst($quote->status) }}</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-gray-400 text-sm">{{ $quote->date->format('M d, Y') }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="px-6 py-12 text-center text-gray-400">No quotes found</td></tr>
                    @endforelse
                </tbody>
            </table>
            @if($quotes->hasPages())
                <div class="px-6 py-4 border-t border-gray-700">{{ $quotes->links() }}</div>
            @endif
        </div>
    </div>
</div>
@endsection