@extends('layouts.app')
@section('title', 'Draft Invoices')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Draft Invoices</h1>
            <p class="text-gray-400">View draft invoices</p>
        </div>

        <div class="bg-gray-800 border border-gray-700 rounded-xl overflow-hidden">
            <table class="w-full">
                <thead class="bg-gray-750">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Invoice #</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Client</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Amount</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Date</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Paid Date</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-gray-400 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($invoices as $invoice)
                        <tr class="hover:bg-gray-750">
                            <td class="px-6 py-4 text-gray-300">{{ $invoice->invoice_number }}</td>
                            <td class="px-6 py-4">
                                <div class="text-white font-medium">{{ $invoice->user->name }}</div>
                                <div class="text-sm text-gray-400">{{ $invoice->user->email }}</div>
                            </td>
                            <td class="px-6 py-4 text-white font-semibold">{{ format_currency($invoice->total) }}</td>
                            <td class="px-6 py-4 text-gray-400 text-sm">{{ $invoice->date->format('M d, Y') }}</td>
                            <td class="px-6 py-4 text-gray-400 text-sm">{{ $invoice->updated_at->format('M d, Y') }}</td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ route('admin.invoices.show', $invoice->id) }}" class="text-blue-400 hover:text-blue-300">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="px-6 py-12 text-center text-gray-400">No draft invoices found</td></tr>
                    @endforelse
                </tbody>
            </table>
            @if($invoices->hasPages())
                <div class="px-6 py-4 border-t border-gray-700">{{ $invoices->links() }}</div>
            @endif
        </div>
    </div>
</div>
@endsection
