@extends('layouts.auth')

@section('title', 'Admin Login')

@section('content')
<div class="animate-fade-in-up">
    <!-- Header -->
    <div class="mb-8">
        <div class="inline-flex items-center px-3 py-1 bg-gradient-to-r from-red-500/20 to-orange-500/20 border border-red-500/30 rounded-full mb-4">
            <svg class="w-4 h-4 text-red-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true" focusable="false">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
            </svg>
            <span class="text-xs font-semibold text-red-300">ADMIN ACCESS</span>
        </div>
        <h2 class="text-3xl font-bold text-white mb-2">Administrator Login</h2>
        <p class="text-gray-400">Secure access to the admin control panel</p>
    </div>

    <!-- Info Message -->
    @if(session('message'))
        <x-alert type="info">
            <p>{{ session('message') }}</p>
        </x-alert>
    @endif

    <!-- Error Messages -->
    @if($errors->any())
        <x-alert type="error">
            <ul class="space-y-1">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </x-alert>
    @endif

    <!-- Login Form -->
    <form method="POST" action="{{ route('admin.login') }}" class="space-y-6">
        @csrf

        <!-- Email Field -->
        <div class="transform transition-all duration-300 hover:scale-[1.01]">
            <label for="email" class="block text-sm font-medium text-gray-300 mb-2">Admin Email Address</label>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="h-5 w-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                    </svg>
                </div>
                <input type="email" name="email" id="email" value="{{ old('email') }}" required autofocus
                    class="w-full pl-12 pr-4 py-3 bg-gray-800/50 border border-gray-700 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent transition backdrop-blur-sm"
                    placeholder="admin@example.com">
            </div>
        </div>

        <!-- Password Field -->
        <div class="transform transition-all duration-300 hover:scale-[1.01]">
            <label for="password" class="block text-sm font-medium text-gray-300 mb-2">Admin Password</label>
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                    <svg class="h-5 w-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                    </svg>
                </div>
                <input type="password" name="password" id="password" required
                    class="w-full pl-12 pr-4 py-3 bg-gray-800/50 border border-gray-700 rounded-lg text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-red-500 focus:border-transparent transition backdrop-blur-sm"
                    placeholder="••••••••">
            </div>
        </div>

        <!-- Remember Me & Forgot Password -->
        <div class="flex items-center justify-between">
            <label class="flex items-center group cursor-pointer">
                <input type="checkbox" name="remember" class="rounded border-gray-600 bg-gray-800 text-red-600 focus:ring-red-500 focus:ring-offset-gray-900">
                <span class="ml-2 text-sm text-gray-400 group-hover:text-gray-300 transition">Remember me</span>
            </label>
            <a href="{{ route('password.request') }}" class="text-sm text-red-400 hover:text-red-300 transition">
                Forgot password?
            </a>
        </div>

        <!-- Submit Button -->
        <button type="submit" 
            class="w-full bg-gradient-to-r from-red-600 to-orange-600 hover:from-red-700 hover:to-orange-700 text-white font-semibold py-3 px-4 rounded-lg transition duration-300 transform hover:scale-[1.02] hover:shadow-xl hover:shadow-red-500/50 flex items-center justify-center space-x-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
            </svg>
            <span>Sign In as Admin</span>
        </button>

        <!-- User Login Link -->
        <div class="text-center pt-4 border-t border-gray-800">
            <p class="text-sm text-gray-400">
                Not an admin? 
                <a href="{{ route('login') }}" class="text-blue-400 hover:text-blue-300 font-medium transition">
                    Sign in as a client
                </a>
            </p>
        </div>
    </form>

    <!-- Security Notice -->
    <div class="mt-6 p-4 bg-gray-800/30 border border-gray-700/50 rounded-lg">
        <div class="flex items-start">
            <svg class="w-5 h-5 text-yellow-400 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
            </svg>
            <div class="text-xs text-gray-400">
                <p class="font-medium text-gray-300 mb-1">Security Notice</p>
                <p>This is a restricted area. All login attempts are logged and monitored. Unauthorized access attempts will be reported to system administrators.</p>
            </div>
        </div>
    </div>
</div>
@endsection
