<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Announcements table
        Schema::create('announcements', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('content');
            $table->date('published_at')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        // Knowledgebase categories table
        Schema::create('knowledgebase_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->integer('order')->default(0);
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        // Knowledgebase articles table
        Schema::create('knowledgebase_articles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained('knowledgebase_categories')->onDelete('cascade');
            $table->string('title');
            $table->text('content');
            $table->integer('views')->default(0);
            $table->boolean('helpful_yes')->default(0);
            $table->boolean('helpful_no')->default(0);
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        // Downloads table
        Schema::create('downloads', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('file_path');
            $table->string('file_size')->nullable();
            $table->integer('download_count')->default(0);
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        // Network issues table
        Schema::create('network_issues', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->enum('status', ['open', 'scheduled', 'resolved'])->default('open');
            $table->enum('priority', ['low', 'medium', 'high', 'critical'])->default('medium');
            $table->timestamp('started_at')->nullable();
            $table->timestamp('resolved_at')->nullable();
            $table->timestamps();
        });

        // Predefined replies table
        Schema::create('predefined_replies', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('content');
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('predefined_replies');
        Schema::dropIfExists('network_issues');
        Schema::dropIfExists('downloads');
        Schema::dropIfExists('knowledgebase_articles');
        Schema::dropIfExists('knowledgebase_categories');
        Schema::dropIfExists('announcements');
    }
};
