<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Add product_id to services table if not exists
        if (!Schema::hasColumn('services', 'product_id')) {
            Schema::table('services', function (Blueprint $table) {
                $table->foreignId('product_id')->nullable()->after('user_id')->constrained()->onDelete('set null');
            });
        }

        // Update tickets table to support more statuses
        if (!Schema::hasColumn('tickets', 'ticket_number')) {
            Schema::table('tickets', function (Blueprint $table) {
                $table->string('ticket_number')->unique()->nullable()->after('id');
            });
        }
        
        if (!Schema::hasColumn('tickets', 'flagged')) {
            Schema::table('tickets', function (Blueprint $table) {
                $table->boolean('flagged')->default(false)->after('priority');
            });
        }

        // Update invoices and tickets status columns for MySQL only
        if (config('database.default') === 'mysql') {
            DB::statement("ALTER TABLE invoices MODIFY status ENUM('draft', 'unpaid', 'paid', 'overdue', 'cancelled', 'refunded') DEFAULT 'unpaid'");
            DB::statement("ALTER TABLE tickets MODIFY status ENUM('open', 'answered', 'customer-reply', 'on-hold', 'in-progress', 'pending', 'closed') DEFAULT 'open'");
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('services', 'product_id')) {
            Schema::table('services', function (Blueprint $table) {
                $table->dropForeign(['product_id']);
                $table->dropColumn('product_id');
            });
        }

        Schema::table('tickets', function (Blueprint $table) {
            $table->dropColumn(['ticket_number', 'flagged']);
        });

        // Revert status enums to original values
        DB::statement("ALTER TABLE invoices MODIFY status ENUM('unpaid', 'paid', 'cancelled', 'refunded') DEFAULT 'unpaid'");
        DB::statement("ALTER TABLE tickets MODIFY status ENUM('open', 'pending', 'answered', 'closed') DEFAULT 'open'");
    }
};
