<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('servers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('hostname');
            $table->string('ip_address');
            $table->enum('type', ['cpanel', 'directadmin', 'plesk', 'custom'])->default('cpanel');
            $table->string('username');
            $table->string('password'); // Encrypted
            $table->integer('port')->default(2087);
            $table->boolean('secure')->default(true); // HTTPS
            $table->boolean('active')->default(true);
            $table->integer('max_accounts')->default(0); // 0 = unlimited
            $table->integer('accounts_count')->default(0);
            $table->string('nameserver1')->nullable();
            $table->string('nameserver2')->nullable();
            $table->string('nameserver3')->nullable();
            $table->string('nameserver4')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('servers');
    }
};
