<?php

namespace App\View\Composers;

use App\Models\Product;
use Illuminate\View\View;

class ClientNavComposer
{
    /**
     * Bind data to the view.
     */
    public function compose(View $view): void
    {
        $hostingProducts = Product::where('type', 'hosting')
            ->where('active', true)
            ->select('id', 'name', 'description')
            ->get();

        $resellerProducts = Product::where('type', 'reseller')
            ->where('active', true)
            ->select('id', 'name', 'description')
            ->get();

        $view->with([
            'hostingProducts' => $hostingProducts,
            'resellerProducts' => $resellerProducts,
        ]);
    }
}
