<?php

namespace App\Services;

use Illuminate\Support\Facades\File;

class ModuleService
{
    protected $modules = [];

    public function loadModules()
    {
        $modulesPath = app_path('Modules');
        
        if (!File::exists($modulesPath)) {
            return;
        }

        $directories = File::directories($modulesPath);

        foreach ($directories as $directory) {
            $moduleName = basename($directory);
            $moduleClass = "App\\Modules\\{$moduleName}\\{$moduleName}Module";

            if (class_exists($moduleClass)) {
                $module = new $moduleClass();
                $this->modules[$moduleName] = $module;

                if (method_exists($module, 'boot')) {
                    $module->boot();
                }
            }
        }
    }

    public function getModules()
    {
        return $this->modules;
    }

    public function callHook($hookName, $data = null)
    {
        foreach ($this->modules as $module) {
            if (method_exists($module, 'hooks')) {
                $hooks = $module->hooks();
                if (isset($hooks[$hookName]) && is_callable($hooks[$hookName])) {
                    call_user_func($hooks[$hookName], $data);
                }
            }
        }
    }
}
