<?php

namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class MailConfigServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        try {
            // Only load mail settings if database is accessible
            if (Schema::hasTable('settings')) {
                $mailer = Setting::get('mail_mailer');

                if ($mailer) {
                    $mailUsername = Setting::get('mail_username', config('mail.mailers.smtp.username'));
                    $mailFromAddress = Setting::get('mail_from_address', config('mail.from.address'));

                    // Use SMTP username as from address if configured to avoid sender verification errors
                    // Most SMTP servers require the From address to match the authenticated username
                    $fromAddress = ! empty($mailUsername) ? $mailUsername : $mailFromAddress;

                    config([
                        'mail.default' => $mailer,
                        'mail.mailers.smtp.host' => Setting::get('mail_host', config('mail.mailers.smtp.host')),
                        'mail.mailers.smtp.port' => Setting::get('mail_port', config('mail.mailers.smtp.port')),
                        'mail.mailers.smtp.encryption' => Setting::get('mail_encryption', config('mail.mailers.smtp.encryption')),
                        'mail.mailers.smtp.username' => $mailUsername,
                        'mail.mailers.smtp.password' => Setting::get('mail_password', config('mail.mailers.smtp.password')),
                        'mail.from.address' => $fromAddress,
                        'mail.from.name' => Setting::get('mail_from_name', config('mail.from.name')),
                    ]);
                }
            }
        } catch (\Exception $e) {
            // Fail silently during installation/migration
        }
    }
}
