<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'company',
        'address',
        'city',
        'state',
        'zip',
        'country',
        'phone',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function isAdmin(): bool
    {
        return $this->role === 'admin';
    }

    public function isClient(): bool
    {
        return $this->role === 'client';
    }

    public function services()
    {
        return $this->hasMany(Service::class);
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }

    public function tickets()
    {
        return $this->hasMany(Ticket::class);
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function domains()
    {
        return $this->hasMany(Domain::class);
    }

    public function messages()
    {
        return $this->hasMany(Message::class);
    }

    public function contacts()
    {
        return $this->hasMany(Contact::class);
    }

    public function quotes()
    {
        return $this->hasMany(Quote::class);
    }

    public function disputes()
    {
        return $this->hasMany(Dispute::class);
    }

    public function accountCredits()
    {
        return $this->hasMany(AccountCredit::class);
    }

    public function cancellationRequests()
    {
        return $this->hasMany(CancellationRequest::class);
    }

    public function affiliate()
    {
        return $this->hasOne(Affiliate::class);
    }
}
