<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'type',
        'active',
        'server_id',
        'features',
    ];

    protected function casts(): array
    {
        return [
            'active' => 'boolean',
            'features' => 'array',
        ];
    }

    public function server()
    {
        return $this->belongsTo(Server::class);
    }

    public function pricing()
    {
        return $this->hasMany(ProductPricing::class);
    }

    public function getPriceForCycle(string $cycle)
    {
        return $this->pricing()->where('billing_cycle', $cycle)->first();
    }
}
