<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KnowledgebaseArticle extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'title',
        'content',
        'views',
        'helpful_yes',
        'helpful_no',
        'active',
    ];

    protected function casts(): array
    {
        return [
            'views' => 'integer',
            'helpful_yes' => 'integer',
            'helpful_no' => 'integer',
            'active' => 'boolean',
        ];
    }

    public function category()
    {
        return $this->belongsTo(KnowledgebaseCategory::class, 'category_id');
    }
}
