<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Cache;
use App\Models\Setting;

class CheckMaintenanceMode
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Cache maintenance mode setting for 5 minutes to reduce database queries
        $maintenanceMode = Cache::remember('maintenance_mode', 300, function () {
            return Setting::get('maintenance_mode', false);
        });
        
        // If maintenance mode is enabled and user is not an admin
        if ($maintenanceMode && (!auth()->check() || !auth()->user()->isAdmin())) {
            // Cache redirect URL as well
            $redirectUrl = Cache::remember('maintenance_redirect_url', 300, function () {
                return Setting::get('maintenance_redirect_url');
            });
            
            if ($redirectUrl) {
                return redirect()->away($redirectUrl);
            }
            
            // Pass cached settings to the view
            $maintenanceSettings = Cache::remember('maintenance_settings', 300, function () {
                return [
                    'message' => Setting::get('maintenance_message'),
                    'site_name' => Setting::get('site_name', config('app.name')),
                ];
            });
            
            return response()->view('errors.maintenance', $maintenanceSettings, 503);
        }

        return $next($request);
    }
}
