<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use App\Models\Service;
use App\Models\DomainPricing;
use Illuminate\Http\Request;

class DomainController extends Controller
{
    public function index()
    {
        $domains = auth()->user()->services()
                             ->where('type', 'domain')
                             ->with('product')
                             ->latest()
                             ->paginate(20);
        
        $stats = [
            'total_domains' => auth()->user()->services()->where('type', 'domain')->count(),
            'active_domains' => auth()->user()->services()->where('type', 'domain')->where('status', 'active')->count(),
            'expiring_soon' => auth()->user()->services()->where('type', 'domain')
                                         ->where('status', 'active')
                                         ->where('next_due_date', '<=', now()->addDays(30))
                                         ->count(),
        ];
        
        return view('client.domains.index', compact('domains', 'stats'));
    }

    public function register()
    {
        return view('client.domains.register');
    }

    public function transfer()
    {
        return view('client.domains.transfer');
    }

    public function pricing()
    {
        $domainPricing = DomainPricing::orderBy('extension')->get();
        
        return view('client.domains.pricing', compact('domainPricing'));
    }
}
