<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Ticket;
use Illuminate\Http\Request;

class TicketController extends Controller
{
    public function index(Request $request)
    {
        return Ticket::where('user_id', $request->user()->id)->paginate();
    }

    public function show(Ticket $ticket)
    {
        $this->authorize('view', $ticket);
        return $ticket->load('replies');
    }
}
