<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    public function index(Request $request)
    {
        return Invoice::where('user_id', $request->user()->id)->paginate();
    }

    public function show(Invoice $invoice)
    {
        $this->authorize('view', $invoice);
        return $invoice->load('items');
    }
}
