<?php

namespace App\Http\Controllers\Admin\Utilities;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Artisan;

class UtilityController extends Controller
{
    public function automationStatus()
    {
        return view('admin.utilities.automation-status');
    }

    public function moduleQueue()
    {
        return view('admin.utilities.module-queue');
    }

    public function registrarTldSync()
    {
        return view('admin.utilities.registrar-tld-sync');
    }

    public function emailCampaigns()
    {
        return view('admin.utilities.email-campaigns');
    }

    public function emailMarketer()
    {
        return view('admin.utilities.email-marketer');
    }

    public function linkTracking()
    {
        return view('admin.utilities.link-tracking');
    }

    public function calendar()
    {
        return view('admin.utilities.calendar');
    }

    public function todoList()
    {
        return view('admin.utilities.todo-list');
    }

    public function whoisLookup()
    {
        return view('admin.utilities.whois-lookup');
    }

    public function domainResolver()
    {
        return view('admin.utilities.domain-resolver');
    }

    public function integrationCode()
    {
        return view('admin.utilities.integration-code');
    }

    public function databaseStatus()
    {
        try {
            DB::connection()->getPdo();
            $status = 'Connected';
            $tables = DB::select('SHOW TABLES');
        } catch (\Exception $e) {
            $status = 'Disconnected';
            $tables = [];
        }
        
        return view('admin.utilities.system.database-status', compact('status', 'tables'));
    }

    public function systemCleanup()
    {
        return view('admin.utilities.system.cleanup');
    }

    public function phpInfo()
    {
        ob_start();
        phpinfo();
        $phpinfo = ob_get_clean();
        
        return view('admin.utilities.system.php-info', compact('phpinfo'));
    }

    public function phpVersionCompatibility()
    {
        $phpVersion = PHP_VERSION;
        $extensions = get_loaded_extensions();
        
        return view('admin.utilities.system.php-version', compact('phpVersion', 'extensions'));
    }
}
