<?php

namespace App\Http\Controllers\Admin\Reports;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use App\Models\User;
use App\Models\Ticket;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index()
    {
        return view('admin.reports.index');
    }

    public function dailyPerformance()
    {
        $today = now()->startOfDay();
        
        $stats = [
            'revenue' => Invoice::where('status', 'paid')
                               ->whereDate('date', $today)
                               ->sum('total'),
            'new_clients' => User::where('role', 'client')
                                  ->whereDate('created_at', $today)
                                  ->count(),
            'new_tickets' => Ticket::whereDate('created_at', $today)->count(),
        ];
        
        return view('admin.reports.daily-performance', compact('stats'));
    }

    public function incomeForecast()
    {
        return view('admin.reports.income-forecast');
    }

    public function annualIncome()
    {
        $year = now()->year;
        
        $monthlyRevenue = Invoice::where('status', 'paid')
                                 ->whereYear('date', $year)
                                 ->selectRaw('MONTH(date) as month, SUM(total) as revenue')
                                 ->groupBy('month')
                                 ->get();
        
        return view('admin.reports.annual-income', compact('monthlyRevenue', 'year'));
    }

    public function newCustomers()
    {
        $customers = User::where('role', 'client')
                         ->latest()
                         ->paginate(50);
        
        return view('admin.reports.new-customers', compact('customers'));
    }

    public function ticketFeedback()
    {
        return view('admin.reports.ticket-feedback');
    }

    public function batchInvoicePdf()
    {
        return view('admin.reports.batch-invoice-pdf');
    }
}
