<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PaymentGateway;
use Illuminate\Http\Request;

class PaymentGatewayController extends Controller
{
    public function index()
    {
        $gateways = PaymentGateway::orderBy('display_order')->get();
        return view('admin.payment-gateways.index', compact('gateways'));
    }

    public function create()
    {
        return view('admin.payment-gateways.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string',
            'slug' => 'required|string|unique:payment_gateways',
            'display_name' => 'required|string',
            'description' => 'nullable|string',
            'is_active' => 'boolean',
            'is_test_mode' => 'boolean',
            'supported_currencies' => 'nullable|array',
            'transaction_fee_percentage' => 'nullable|numeric',
            'transaction_fee_fixed' => 'nullable|numeric',
        ]);

        $validated['config'] = $request->input('config', []);
        
        PaymentGateway::create($validated);

        return redirect()->route('admin.gateways.index')
            ->with('success', 'Payment gateway created successfully');
    }

    public function edit(PaymentGateway $gateway)
    {
        return view('admin.payment-gateways.edit', compact('gateway'));
    }

    public function update(Request $request, PaymentGateway $gateway)
    {
        $validated = $request->validate([
            'name' => 'required|string',
            'slug' => 'required|string|unique:payment_gateways,slug,' . $gateway->id,
            'display_name' => 'required|string',
            'description' => 'nullable|string',
            'is_active' => 'boolean',
            'is_test_mode' => 'boolean',
            'supported_currencies' => 'nullable|array',
            'transaction_fee_percentage' => 'nullable|numeric',
            'transaction_fee_fixed' => 'nullable|numeric',
        ]);

        $validated['config'] = $request->input('config', []);
        
        $gateway->update($validated);

        return redirect()->route('admin.gateways.index')
            ->with('success', 'Payment gateway updated successfully');
    }

    public function destroy(PaymentGateway $gateway)
    {
        $gateway->delete();

        return redirect()->route('admin.gateways.index')
            ->with('success', 'Payment gateway deleted successfully');
    }

    public function toggle(PaymentGateway $gateway)
    {
        $gateway->update(['is_active' => !$gateway->is_active]);

        return redirect()->route('admin.gateways.index')
            ->with('success', 'Gateway status updated successfully');
    }
}
