<?php

namespace App\Http\Controllers\Admin\Orders;

use App\Http\Controllers\Controller;
use App\Models\Service;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        $query = Service::with(['user', 'product']);

        if ($request->has('status')) {
            $query->where('status', $request->get('status'));
        }

        $orders = $query->latest()->paginate(20);
        
        return view('admin.orders.index', compact('orders'));
    }

    public function pending()
    {
        $orders = Service::where('status', 'pending')
                         ->with(['user', 'product'])
                         ->latest()
                         ->paginate(20);
        
        return view('admin.orders.pending', compact('orders'));
    }

    public function active()
    {
        $orders = Service::where('status', 'active')
                         ->with(['user', 'product'])
                         ->latest()
                         ->paginate(20);
        
        return view('admin.orders.active', compact('orders'));
    }

    public function fraud()
    {
        $orders = Service::where('status', 'fraud')
                         ->with(['user', 'product'])
                         ->latest()
                         ->paginate(20);
        
        return view('admin.orders.fraud', compact('orders'));
    }

    public function cancelled()
    {
        $orders = Service::where('status', 'cancelled')
                         ->with(['user', 'product'])
                         ->latest()
                         ->paginate(20);
        
        return view('admin.orders.cancelled', compact('orders'));
    }
}
