<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    public function index() { return view('admin.invoices.index', ['invoices' => Invoice::with('user')->paginate(25)]); }
    public function create() { return view('admin.invoices.create'); }
    public function store(Request $request) { /* implement */ return redirect()->route('admin.invoices.index'); }
    public function show(Invoice $invoice) { return view('admin.invoices.show', compact('invoice')); }
    public function edit(Invoice $invoice) { return view('admin.invoices.edit', compact('invoice')); }
    public function update(Request $request, Invoice $invoice) { /* implement */ return redirect()->route('admin.invoices.index'); }
    public function destroy(Invoice $invoice) { $invoice->delete(); return redirect()->route('admin.invoices.index'); }
}
