<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DomainPricing;
use Illuminate\Http\Request;

class DomainPricingController extends Controller
{
    public function index()
    {
        $domainPricing = DomainPricing::paginate(config('app.items_per_page'));
        return view('admin.domain-pricing.index', compact('domainPricing'));
    }

    public function create()
    {
        return view('admin.domain-pricing.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'extension' => 'required|string|max:50|unique:domain_pricing,extension',
            'register_price' => 'required|numeric|min:0',
            'renew_price' => 'required|numeric|min:0',
            'transfer_price' => 'required|numeric|min:0',
            'active' => 'boolean',
        ]);

        $validated['active'] = $request->has('active');

        DomainPricing::create($validated);

        return redirect()->route('admin.domain-pricing.index')->with('success', 'Domain pricing added successfully');
    }

    public function edit(DomainPricing $domainPricing)
    {
        return view('admin.domain-pricing.edit', compact('domainPricing'));
    }

    public function update(Request $request, DomainPricing $domainPricing)
    {
        $validated = $request->validate([
            'extension' => 'required|string|max:50|unique:domain_pricing,extension,' . $domainPricing->id,
            'register_price' => 'required|numeric|min:0',
            'renew_price' => 'required|numeric|min:0',
            'transfer_price' => 'required|numeric|min:0',
            'active' => 'boolean',
        ]);

        $validated['active'] = $request->has('active');

        $domainPricing->update($validated);

        return redirect()->route('admin.domain-pricing.index')->with('success', 'Domain pricing updated successfully');
    }

    public function destroy(DomainPricing $domainPricing)
    {
        $domainPricing->delete();
        return redirect()->route('admin.domain-pricing.index')->with('success', 'Domain pricing deleted successfully');
    }
}
