<?php

namespace App\Http\Controllers\Admin\Billing;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    public function index(Request $request)
    {
        $query = Invoice::with('user');

        if ($request->has('status')) {
            $status = $request->get('status');
            if ($status === 'overdue') {
                $query->where('status', 'unpaid')
                      ->where('due_date', '<', now());
            } else {
                $query->where('status', $status);
            }
        }

        $invoices = $query->latest()->paginate(20);
        
        return view('admin.billing.invoices.index', compact('invoices'));
    }

    public function paid()
    {
        $invoices = Invoice::where('status', 'paid')
                           ->with('user')
                           ->latest()
                           ->paginate(20);
        
        return view('admin.billing.invoices.paid', compact('invoices'));
    }

    public function draft()
    {
        $invoices = Invoice::where('status', 'draft')
                           ->with('user')
                           ->latest()
                           ->paginate(20);
        
        return view('admin.billing.invoices.draft', compact('invoices'));
    }

    public function unpaid()
    {
        $invoices = Invoice::where('status', 'unpaid')
                           ->with('user')
                           ->latest()
                           ->paginate(20);
        
        return view('admin.billing.invoices.unpaid', compact('invoices'));
    }

    public function overdue()
    {
        $invoices = Invoice::where('status', 'unpaid')
                           ->where('due_date', '<', now())
                           ->with('user')
                           ->latest()
                           ->paginate(20);
        
        return view('admin.billing.invoices.overdue', compact('invoices'));
    }

    public function cancelled()
    {
        $invoices = Invoice::where('status', 'cancelled')
                           ->with('user')
                           ->latest()
                           ->paginate(20);
        
        return view('admin.billing.invoices.cancelled', compact('invoices'));
    }

    public function refunded()
    {
        $invoices = Invoice::where('status', 'refunded')
                           ->with('user')
                           ->latest()
                           ->paginate(20);
        
        return view('admin.billing.invoices.refunded', compact('invoices'));
    }
}
