# Contributing to BillingCS

Thank you for considering contributing to BillingCS! This document outlines the process for contributing to this project.

## Code of Conduct

Be respectful and professional in all interactions. We aim to foster an inclusive and welcoming community.

## How to Contribute

### Reporting Bugs

If you find a bug, please create an issue with:
- Clear title and description
- Steps to reproduce
- Expected behavior
- Actual behavior
- Environment details (PHP version, Laravel version, OS)
- Screenshots if applicable

### Suggesting Features

Feature requests are welcome! Please:
- Check if the feature has already been requested
- Clearly describe the feature and its benefits
- Provide examples of how it would be used

### Pull Requests

1. **Fork the repository**
2. **Create a feature branch**: `git checkout -b feature/your-feature-name`
3. **Make your changes**
4. **Follow coding standards**: Use Laravel Pint for code formatting
5. **Write tests**: If adding new features
6. **Commit your changes**: Use clear, descriptive commit messages
7. **Push to your fork**: `git push origin feature/your-feature-name`
8. **Submit a pull request**

### Coding Standards

- Follow PSR-12 coding standards
- Use Laravel best practices
- Write meaningful comments
- Keep methods small and focused
- Use type hints where possible

### Running Tests

```bash
php artisan test
```

### Code Formatting

```bash
./vendor/bin/pint
```

## Development Setup

See INSTALLATION.md for detailed setup instructions.

## Questions?

Feel free to open an issue for any questions about contributing.

## License

By contributing to BillingCS, you agree that your contributions will be licensed under the MIT License.
